/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.parser.sbml.converter;

import de.bioforscher.singa.simulation.model.parameters.SimulationParameter;
import de.bioforscher.singa.simulation.model.rules.AppliedExpression;
import de.bioforscher.singa.simulation.modules.reactions.implementations.DynamicKineticLaw;
import de.bioforscher.singa.simulation.parser.sbml.FunctionReference;
import de.bioforscher.singa.simulation.parser.sbml.converter.SBMLExpressionConverter;
import java.util.Map;
import javax.measure.Unit;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.LocalParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.AbstractUnit;

public class SBMLKineticLawConverter {
    private static final Logger logger = LoggerFactory.getLogger(SBMLKineticLawConverter.class);
    private final Map<String, Unit<?>> units;
    private final SBMLExpressionConverter expressionConverter;

    public SBMLKineticLawConverter(Map<String, Unit<?>> units, Map<String, FunctionReference> functions, Map<String, SimulationParameter<?>> globalParameters) {
        this.units = units;
        this.expressionConverter = new SBMLExpressionConverter(this.units, functions, globalParameters);
    }

    public DynamicKineticLaw convertKineticLaw(KineticLaw sbmlKineticLaw) {
        if (!sbmlKineticLaw.getMath().toString().equals("NaN")) {
            String unitIdentifier = sbmlKineticLaw.getDerivedUnitDefinition().getId();
            Unit<?> parameterUnit = unitIdentifier.equalsIgnoreCase("dimensionless") || unitIdentifier.isEmpty() ? AbstractUnit.ONE : this.units.get(unitIdentifier);
            logger.debug("Creating kinetic law with expression {} ...", (Object)sbmlKineticLaw.getMath().toString());
            AppliedExpression appliedExpression = this.expressionConverter.convertRawExpression(sbmlKineticLaw.getMath(), (ListOf<LocalParameter>)sbmlKineticLaw.getListOfLocalParameters(), parameterUnit);
            return new DynamicKineticLaw(appliedExpression);
        }
        logger.warn("Could not parse a valid expression for this reaction.");
        return null;
    }
}

