/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.parser.sbml.converter;

import de.bioforscher.singa.simulation.model.parameters.SimulationParameter;
import de.bioforscher.singa.simulation.model.rules.AppliedExpression;
import de.bioforscher.singa.simulation.parser.sbml.FunctionReference;
import de.bioforscher.singa.simulation.parser.sbml.converter.SBMLParameterConverter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.Unit;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.LocalParameter;

public class SBMLExpressionConverter {
    private final Map<String, Unit<?>> units;
    private final Map<String, FunctionReference> functions;
    private final Map<String, SimulationParameter<?>> globalParameters;
    private AppliedExpression currentExpression;

    public SBMLExpressionConverter(Map<String, Unit<?>> units, Map<String, FunctionReference> functions, Map<String, SimulationParameter<?>> globalParameters) {
        this.units = units;
        this.functions = functions;
        this.globalParameters = globalParameters;
    }

    public AppliedExpression convertRawExpression(ASTNode sbmlExpression, ListOf<LocalParameter> additionalParameters, Unit<?> resultUnit) {
        String expressionString = this.replaceFunction(sbmlExpression.toString());
        this.currentExpression = new AppliedExpression(expressionString, resultUnit);
        this.assignLocalParameters(additionalParameters);
        this.assignGlobalParameters(expressionString);
        return this.currentExpression;
    }

    public AppliedExpression convertRawExpression(ASTNode sbmlExpression, Unit<?> resultUnit) {
        String expressionString = this.replaceFunction(sbmlExpression.toString());
        this.currentExpression = new AppliedExpression(expressionString, resultUnit);
        this.assignGlobalParameters(expressionString);
        return this.currentExpression;
    }

    private String replaceFunction(String kineticLawString) {
        String replacedString = kineticLawString;
        for (String functionIdentifier : this.functions.keySet()) {
            if (!kineticLawString.contains(functionIdentifier)) continue;
            replacedString = this.functions.get(functionIdentifier).replaceInEquation(replacedString);
        }
        return replacedString;
    }

    private void assignLocalParameters(ListOf<LocalParameter> additionalParameters) {
        SBMLParameterConverter converter = new SBMLParameterConverter(this.units);
        for (LocalParameter parameter : additionalParameters) {
            this.currentExpression.setParameter(converter.convertLocalParameter(parameter));
        }
    }

    private void assignGlobalParameters(String kineticLawString) {
        for (String primaryIdentifier : this.globalParameters.keySet()) {
            Pattern pattern = Pattern.compile("(\\W|^)(" + primaryIdentifier + ")(\\W|$)");
            Matcher matcher = pattern.matcher(kineticLawString);
            if (!matcher.find()) continue;
            this.currentExpression.setParameter(this.globalParameters.get(primaryIdentifier));
        }
    }
}

