/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.parser.sbml.converter;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.simulation.model.parameters.SimulationParameter;
import de.bioforscher.singa.simulation.model.rules.AppliedExpression;
import de.bioforscher.singa.simulation.parser.sbml.FunctionReference;
import de.bioforscher.singa.simulation.parser.sbml.converter.SBMLExpressionConverter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.Unit;
import org.sbml.jsbml.AssignmentRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.AbstractUnit;

public class SBMLAssignmentRuleConverter {
    private static final Logger logger = LoggerFactory.getLogger(SBMLAssignmentRuleConverter.class);
    private final Map<String, Unit<?>> units;
    private final Map<String, ChemicalEntity> entities;
    private final SBMLExpressionConverter expressionConverter;

    public SBMLAssignmentRuleConverter(Map<String, Unit<?>> units, Map<String, ChemicalEntity> entities, Map<String, FunctionReference> functions, Map<String, SimulationParameter<?>> globalParameters) {
        this.units = units;
        this.entities = entities;
        this.expressionConverter = new SBMLExpressionConverter(units, functions, globalParameters);
    }

    public de.bioforscher.singa.simulation.model.rules.AssignmentRule convertAssignmentRule(AssignmentRule sbmlAssignmentRule) {
        String unitIdentifier = sbmlAssignmentRule.getDerivedUnitDefinition().getId();
        Unit<?> parameterUnit = unitIdentifier.equalsIgnoreCase("dimensionless") || unitIdentifier.isEmpty() ? AbstractUnit.ONE : this.units.get(unitIdentifier);
        AppliedExpression appliedExpression = this.expressionConverter.convertRawExpression(sbmlAssignmentRule.getMath(), parameterUnit);
        ChemicalEntity targetEntity = this.entities.get(sbmlAssignmentRule.getVariable());
        de.bioforscher.singa.simulation.model.rules.AssignmentRule assignmentRule = new de.bioforscher.singa.simulation.model.rules.AssignmentRule(targetEntity, appliedExpression);
        for (String identifier : this.entities.keySet()) {
            Pattern pattern = Pattern.compile("(\\W|^)(" + identifier + ")(\\W|$)");
            Matcher matcher = pattern.matcher(sbmlAssignmentRule.getMath().toString());
            if (!matcher.find()) continue;
            assignmentRule.referenceChemicalEntityToParameter(identifier, this.entities.get(identifier));
        }
        return assignmentRule;
    }
}

