/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.parser.sbml;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.entities.ComplexedChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.entities.Protein;
import de.bioforscher.singa.chemistry.descriptive.entities.Species;
import de.bioforscher.singa.chemistry.descriptive.features.databases.chebi.ChEBIParserService;
import de.bioforscher.singa.chemistry.descriptive.features.databases.uniprot.UniProtParserService;
import de.bioforscher.singa.features.identifiers.ChEBIIdentifier;
import de.bioforscher.singa.features.identifiers.SimpleStringIdentifier;
import de.bioforscher.singa.features.identifiers.UniProtIdentifier;
import de.bioforscher.singa.features.identifiers.model.Identifier;
import de.bioforscher.singa.features.model.Feature;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.simulation.model.compartments.EnclosedCompartment;
import de.bioforscher.singa.simulation.model.parameters.SimulationParameter;
import de.bioforscher.singa.simulation.model.rules.AssignmentRule;
import de.bioforscher.singa.simulation.modules.reactions.implementations.DynamicReaction;
import de.bioforscher.singa.simulation.parser.sbml.FunctionReference;
import de.bioforscher.singa.simulation.parser.sbml.converter.SBMLAssignmentRuleConverter;
import de.bioforscher.singa.simulation.parser.sbml.converter.SBMLParameterConverter;
import de.bioforscher.singa.simulation.parser.sbml.converter.SBMLReactionConverter;
import de.bioforscher.singa.simulation.parser.sbml.converter.SBMLUnitConverter;
import de.bioforscher.singa.structure.features.molarmass.MolarMass;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.measure.Unit;
import javax.xml.stream.XMLStreamException;
import org.sbml.jsbml.CVTerm;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.UnitDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.AbstractUnit;
import tec.uom.se.quantity.Quantities;

public class SBMLParser {
    private static final Logger logger = LoggerFactory.getLogger(SBMLParser.class);
    private static final FeatureOrigin defaultOrigin = new FeatureOrigin(FeatureOrigin.OriginType.MANUAL_ANNOTATION, "Defaulted during SBML Parsing, due to lack of information.", "none");
    private final Map<EnclosedCompartment, Double> compartments;
    private final Map<String, ChemicalEntity> entities = new HashMap<String, ChemicalEntity>();
    private final Map<ChemicalEntity, Double> startingConcentrations;
    private final Map<Identifier, ChemicalEntity> entitiesByDatabaseId = new HashMap<Identifier, ChemicalEntity>();
    private final Map<String, FunctionReference> functions;
    private final List<AssignmentRule> assignmentRules;
    private SBMLDocument document;
    private Map<String, Unit<?>> units;
    private List<DynamicReaction> reactions;
    private Map<String, SimulationParameter<?>> globalParameters;

    public SBMLParser(InputStream inputStream) {
        this.startingConcentrations = new HashMap<ChemicalEntity, Double>();
        this.reactions = new ArrayList<DynamicReaction>();
        this.globalParameters = new HashMap();
        this.functions = new HashMap<String, FunctionReference>();
        this.assignmentRules = new ArrayList<AssignmentRule>();
        this.compartments = new HashMap<EnclosedCompartment, Double>();
        this.initializeDocument(inputStream);
    }

    private void initializeDocument(InputStream inputStream) {
        SBMLReader reader = new SBMLReader();
        logger.info("Parsing SBML...");
        try {
            this.document = reader.readSBMLFromStream(inputStream);
        }
        catch (XMLStreamException e) {
            logger.error("Could not read SBML File.");
            e.printStackTrace();
        }
    }

    public Map<String, ChemicalEntity> getChemicalEntities() {
        return this.entities;
    }

    public Map<EnclosedCompartment, Double> getCompartments() {
        return this.compartments;
    }

    public List<DynamicReaction> getReactions() {
        return this.reactions;
    }

    public Map<ChemicalEntity, Double> getStartingConcentrations() {
        return this.startingConcentrations;
    }

    public Map<String, SimulationParameter<?>> getGlobalParameters() {
        return this.globalParameters;
    }

    public List<AssignmentRule> getAssignmentRules() {
        return this.assignmentRules;
    }

    public void parse() {
        this.parseUnits();
        this.parseGlobalParameters();
        this.parseCompartments();
        this.parseFunctions();
        this.parseSpecies();
        this.parseReactions();
        this.parseStartingConcentrations();
        this.parseAssignmentRules();
    }

    private void parseCompartments() {
        logger.info("Parsing Compartments ...");
        this.document.getModel().getListOfCompartments().forEach(compartment -> {
            EnclosedCompartment singaCompartment = new EnclosedCompartment(compartment.getId(), compartment.getName());
            this.compartments.put(singaCompartment, compartment.getSize());
            this.globalParameters.put(singaCompartment.getIdentifier(), new SimulationParameter(singaCompartment.getIdentifier(), Quantities.getQuantity((Number)compartment.getSize(), (Unit)AbstractUnit.ONE)));
        });
    }

    private void parseSpecies() {
        logger.info("Parsing Chemical Entity Data ...");
        this.document.getModel().getListOfSpecies().forEach(species -> {
            logger.debug("Parsing Chemical Entity {} ...", (Object)species.getId());
            if (species.getAnnotation().getCVTermCount() == 1) {
                CVTerm term = species.getAnnotation().getCVTerm(0);
                if (term.getQualifier() == CVTerm.Qualifier.BQB_IS || term.getQualifier() == CVTerm.Qualifier.BQB_IS_VERSION_OF) {
                    if (term.getResourceCount() == 1) {
                        logger.debug("Chemical Entity {} is annotated with one {} resource", (Object)species.getId(), (Object)term.getQualifier().getElementNameEquivalent());
                        this.parseAndAddSingularComponent(species.getId(), term, (Species)species);
                    } else if (this.resourcesHaveTheSameOrigin(term)) {
                        logger.debug("Chemical Entity {} is annotated with multiple {} resources from the same origin.", (Object)species.getId(), (Object)term.getQualifier().getElementNameEquivalent());
                        this.parseAndAddComplexComponent(species.getId(), (Species)species, term);
                    } else {
                        logger.debug("Chemical Entity {} is annotated with multiple {} resources from different sources.", (Object)species.getId(), (Object)term.getQualifier().getElementNameEquivalent());
                        this.parseAndAddSingularComponent(species.getId(), term, (Species)species);
                    }
                } else if (term.getQualifier() == CVTerm.Qualifier.BQB_HAS_PART) {
                    if (this.resourcesHaveTheSameOrigin(term)) {
                        logger.debug("Chemical Entity {} is annotated with multiple {} resources from the same origin.", (Object)species.getId(), (Object)term.getQualifier().getElementNameEquivalent());
                        this.parseAndAddComplexComponent(species.getId(), (Species)species, term);
                    } else {
                        logger.debug("Chemical Entity {} is annotated with multiple {} resources from different sources.", (Object)species.getId(), (Object)term.getQualifier().getElementNameEquivalent());
                        this.parseAndAddAllComponents(species.getId(), term);
                    }
                }
            } else {
                logger.debug("Chemical Entity {} is annotated with multiple annotations.", (Object)species.getId());
                this.parseAndAddAllComponents(species.getId(), species.getAnnotation().getListOfCVTerms());
            }
        });
    }

    private void parseAssignmentRules() {
        logger.info("Parsing Assignment Rules ...");
        SBMLAssignmentRuleConverter converter = new SBMLAssignmentRuleConverter(this.units, this.entities, this.functions, this.globalParameters);
        this.document.getModel().getListOfRules().forEach(rule -> {
            if (rule.isAssignment()) {
                this.assignmentRules.add(converter.convertAssignmentRule((org.sbml.jsbml.AssignmentRule)rule));
            }
        });
    }

    private void parseFunctions() {
        logger.info("Parsing Functions ...");
        this.document.getModel().getListOfFunctionDefinitions().forEach(function -> this.functions.put(function.getId(), new FunctionReference(function.getId(), function.getMath().toString())));
    }

    private void parseReactions() {
        logger.info("Parsing Reactions ...");
        SBMLReactionConverter converter = new SBMLReactionConverter(this.units, this.entities, this.functions, this.globalParameters);
        this.reactions = converter.convertReactions((ListOf<Reaction>)this.document.getModel().getListOfReactions());
    }

    private void parseStartingConcentrations() {
        logger.info("Parsing initial concentrations ...");
        this.document.getModel().getListOfSpecies().forEach(species -> {
            ChemicalEntity entity = this.entities.get(species.getId());
            this.startingConcentrations.put(entity, species.getInitialConcentration());
        });
    }

    private void parseUnits() {
        logger.info("Parsing units ...");
        SBMLUnitConverter converter = new SBMLUnitConverter();
        this.units = converter.convertUnits((ListOf<UnitDefinition>)this.document.getModel().getListOfUnitDefinitions());
    }

    private void parseGlobalParameters() {
        logger.info("Parsing global parameters ...");
        SBMLParameterConverter converter = new SBMLParameterConverter(this.units);
        this.globalParameters = converter.convertSimulationParameters((ListOf<Parameter>)this.document.getModel().getListOfParameters());
    }

    private void parseAndAddSingularComponent(String identifier, CVTerm cvTerm, Species species) {
        for (String resource : cvTerm.getResources()) {
            Optional<ChemicalEntity> entity = this.parseEntity(identifier, resource);
            if (!entity.isPresent()) continue;
            this.entities.put(identifier, entity.get());
            return;
        }
        this.entities.put(identifier, this.createReferenceEntity(species));
    }

    private void parseAndAddComplexComponent(String identifier, Species species, CVTerm cvTerm) {
        ComplexedChemicalEntity complex = (ComplexedChemicalEntity)new ComplexedChemicalEntity.Builder(identifier).build();
        for (String resource : cvTerm.getResources()) {
            Optional<ChemicalEntity> chemicalEntity = this.parseEntity(resource);
            chemicalEntity.ifPresent(arg_0 -> ((ComplexedChemicalEntity)complex).addAssociatedPart(arg_0));
        }
        if (complex.getAssociatedParts().size() > 1) {
            logger.debug("Parsed Chemical Entity as {}", (Object)complex);
            this.entities.put(identifier, (ChemicalEntity)complex);
        } else {
            ChemicalEntity referenceEntity = this.createReferenceEntity(species);
            this.entities.put(referenceEntity.getIdentifier().toString(), referenceEntity);
        }
    }

    private ChemicalEntity createReferenceEntity(Species species) {
        return ((Species.Builder)((Species.Builder)new Species.Builder(species.getId()).name(species.getName())).assignFeature((Feature)new MolarMass(10.0, defaultOrigin))).build();
    }

    private void parseAndAddAllComponents(String identifier, CVTerm cvTerm) {
        ComplexedChemicalEntity complex = (ComplexedChemicalEntity)new ComplexedChemicalEntity.Builder(identifier).build();
        for (String resource : cvTerm.getResources()) {
            this.addPartToComplex(complex, resource);
        }
        this.checkAndAddComplexedChemicalEntity(identifier, complex);
    }

    private void parseAndAddAllComponents(String identifier, List<CVTerm> cvTerms) {
        ComplexedChemicalEntity complex = (ComplexedChemicalEntity)new ComplexedChemicalEntity.Builder(identifier).build();
        cvTerms.forEach(term -> {
            if (term.getQualifier() == CVTerm.Qualifier.BQB_HAS_PART) {
                for (String resource : term.getResources()) {
                    this.addPartToComplex(complex, resource);
                }
            }
        });
        this.checkAndAddComplexedChemicalEntity(identifier, complex);
    }

    private void addPartToComplex(ComplexedChemicalEntity complex, String resource) {
        Optional<ChemicalEntity> chemicalEntityOptional = this.parseEntity(resource);
        chemicalEntityOptional.ifPresent(chemicalEntity -> {
            if (!complex.getAssociatedChemicalEntities().contains(chemicalEntity)) {
                complex.addAssociatedPart(chemicalEntity);
            }
        });
    }

    private void checkAndAddComplexedChemicalEntity(String identifier, ComplexedChemicalEntity complex) {
        if (complex.getAssociatedChemicalEntities().size() == 1) {
            ChemicalEntity parsedPart = (ChemicalEntity)complex.getAssociatedParts().keySet().iterator().next();
            logger.debug("Parsed Chemical Entity as {}", (Object)parsedPart);
            this.entities.put(identifier, parsedPart);
        } else if (complex.getAssociatedChemicalEntities().isEmpty()) {
            de.bioforscher.singa.chemistry.descriptive.entities.Species species = (de.bioforscher.singa.chemistry.descriptive.entities.Species)((Species.Builder)new Species.Builder(identifier).assignFeature((Feature)new MolarMass(10.0, defaultOrigin))).build();
            logger.debug("Parsed Chemical Entity as {}", (Object)species);
            this.entities.put(identifier, (ChemicalEntity)species);
        } else {
            logger.debug("Parsed Chemical Entity as {}", (Object)complex);
            this.entities.put(identifier, (ChemicalEntity)complex);
        }
    }

    private Optional<ChemicalEntity> parseEntity(String primaryIdentifier, String resource) {
        Matcher matcherChEBI = ChEBIIdentifier.PATTERN.matcher(resource);
        if (matcherChEBI.find()) {
            ChEBIIdentifier identifier = new ChEBIIdentifier(matcherChEBI.group(0));
            if (this.entities.containsKey(primaryIdentifier)) {
                logger.debug("Already parsed Chemical Entity for {}", (Object)primaryIdentifier);
                return Optional.of(this.entities.get(primaryIdentifier));
            }
            de.bioforscher.singa.chemistry.descriptive.entities.Species species = ChEBIParserService.parse((String)identifier.toString(), (String)primaryIdentifier);
            this.entities.put(primaryIdentifier, (ChemicalEntity)species);
            this.entitiesByDatabaseId.put((Identifier)identifier, (ChemicalEntity)species);
            return Optional.of(species);
        }
        Matcher matcherUniProt = UniProtIdentifier.PATTERN.matcher(resource);
        if (matcherUniProt.find()) {
            UniProtIdentifier identifier = new UniProtIdentifier(matcherUniProt.group(0));
            if (this.entities.containsKey(primaryIdentifier)) {
                logger.debug("Already parsed Chemical Entity for {}", (Object)primaryIdentifier);
                return Optional.of(this.entities.get(primaryIdentifier));
            }
            Protein protein = UniProtParserService.parse((String)identifier.toString(), (String)primaryIdentifier);
            this.entities.put(primaryIdentifier, (ChemicalEntity)protein);
            this.entitiesByDatabaseId.put((Identifier)identifier, (ChemicalEntity)protein);
            return Optional.of(protein);
        }
        return Optional.empty();
    }

    private Optional<ChemicalEntity> parseEntity(String resource) {
        Matcher matcherChEBI = ChEBIIdentifier.PATTERN.matcher(resource);
        if (matcherChEBI.find()) {
            ChEBIIdentifier identifier = new ChEBIIdentifier(matcherChEBI.group(0));
            if (this.entitiesByDatabaseId.containsKey(identifier)) {
                logger.debug("Already parsed Chemical Entity for {}", (Object)identifier);
                return Optional.of(this.entitiesByDatabaseId.get(identifier));
            }
            de.bioforscher.singa.chemistry.descriptive.entities.Species species = ChEBIParserService.parse((String)identifier.toString());
            this.entitiesByDatabaseId.put((Identifier)identifier, (ChemicalEntity)species);
            return Optional.of(species);
        }
        Matcher matcherUniProt = UniProtIdentifier.PATTERN.matcher(resource);
        if (matcherUniProt.find()) {
            UniProtIdentifier identifier = new UniProtIdentifier(matcherUniProt.group(0));
            if (this.entitiesByDatabaseId.containsKey(identifier)) {
                logger.debug("Already parsed Chemical Entity for {}", (Object)identifier);
                return Optional.of(this.entitiesByDatabaseId.get(identifier));
            }
            Protein protein = UniProtParserService.parse((String)identifier.toString());
            this.entitiesByDatabaseId.put((Identifier)identifier, (ChemicalEntity)protein);
            return Optional.of(protein);
        }
        return Optional.empty();
    }

    private boolean resourcesHaveTheSameOrigin(CVTerm term) {
        HashSet origins = new HashSet();
        term.getResources().forEach(resource -> {
            if (ChEBIIdentifier.PATTERN.matcher((CharSequence)resource).find()) {
                origins.add(ChEBIIdentifier.class.getName());
            } else if (UniProtIdentifier.PATTERN.matcher((CharSequence)resource).find()) {
                origins.add(UniProtIdentifier.class.getName());
            } else {
                origins.add(SimpleStringIdentifier.class.getName());
            }
        });
        return origins.size() == 1;
    }
}

