/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.parser.sbml;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionReference {
    private final String identifier;
    private final List<String> parameters;
    private String equation;

    public FunctionReference(String identifier, String equation, List<String> parameters) {
        this.identifier = identifier;
        this.equation = equation;
        this.parameters = parameters;
    }

    public FunctionReference(String identifier, String functionMathString) {
        this.identifier = identifier;
        this.parameters = new ArrayList<String>();
        String content = functionMathString.substring(7, functionMathString.length() - 1);
        String[] split = content.split(",");
        for (int i = 0; i < split.length; ++i) {
            if (i == split.length - 1) {
                this.equation = split[i].trim();
                continue;
            }
            this.parameters.add(split[i].trim());
        }
    }

    public String replaceInEquation(String equationMathString) {
        Pattern pattern = Pattern.compile(this.identifier + "\\((.[^)]+)\\)");
        Matcher matcher = pattern.matcher(equationMathString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String[] functionParameters = matcher.group(1).split(",");
            String preparedFunction = this.prepareEquation(functionParameters);
            if (!matcher.group(0).equals(equationMathString)) {
                preparedFunction = "(" + preparedFunction + ")";
            }
            matcher.appendReplacement(sb, preparedFunction);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String prepareEquation(String[] functionParameters) {
        String replacedFunction = this.equation;
        for (int i = 0; i < this.parameters.size(); ++i) {
            Pattern pattern = Pattern.compile("(\\W|^)(" + this.parameters.get(i) + ")(\\W|$)");
            Matcher matcher = pattern.matcher(replacedFunction);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, matcher.group(1) + functionParameters[i].trim() + matcher.group(3));
            }
            matcher.appendTail(sb);
            replacedFunction = sb.toString();
        }
        return replacedFunction;
    }
}

