/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.transport;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.entities.Transporter;
import de.bioforscher.singa.chemistry.descriptive.features.permeability.OsmoticPermeability;
import de.bioforscher.singa.features.model.Featureable;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.NodeState;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.model.concentrations.MembraneContainer;
import de.bioforscher.singa.simulation.modules.model.AbstractNeighbourIndependentModule;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.quantity.Quantities;

public class SingleFileChannelMembraneTransport
extends AbstractNeighbourIndependentModule {
    private Transporter transporter;
    private ChemicalEntity cargo;
    private Set<ChemicalEntity> solutes;

    public SingleFileChannelMembraneTransport(Simulation simulation, Transporter transporter, ChemicalEntity cargo, Set<ChemicalEntity> solutes) {
        super(simulation);
        this.transporter = transporter;
        this.cargo = cargo;
        this.solutes = solutes;
        this.onlyApplyIf(node -> node.getState().equals((Object)NodeState.MEMBRANE));
        this.addDeltaFunction(this::calculateInnerPhaseDelta, this::onlyInnerPhase);
        this.addDeltaFunction(this::calculateOuterPhaseDelta, this::onlyOuterPhase);
    }

    private boolean onlyOuterPhase(ConcentrationContainer concentrationContainer) {
        MembraneContainer container = (MembraneContainer)concentrationContainer;
        return this.isOuterPhase(container) && this.isCargo() && this.transporterInMembrane(container);
    }

    private Delta calculateOuterPhaseDelta(ConcentrationContainer concentrationContainer) {
        double value;
        ChemicalEntity entity = this.getCurrentChemicalEntity();
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        if (entity.equals((Object)this.cargo)) {
            double permeability = ((Quantity)this.getFeature((Featureable)this.transporter, OsmoticPermeability.class)).getValue().doubleValue();
            value = this.getSoluteDelta(membraneContainer) * permeability * membraneContainer.getInnerMembraneLayerConcentration((ChemicalEntity)this.transporter).getValue().doubleValue() * 10000.0;
        } else {
            value = 0.0;
        }
        return new Delta(this, membraneContainer.getOuterPhaseSection(), entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)value, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    private boolean onlyInnerPhase(ConcentrationContainer concentrationContainer) {
        MembraneContainer container = (MembraneContainer)concentrationContainer;
        return this.isInnerPhase(container) && this.isCargo() && this.transporterInMembrane(container);
    }

    private Delta calculateInnerPhaseDelta(ConcentrationContainer concentrationContainer) {
        double value;
        ChemicalEntity entity = this.getCurrentChemicalEntity();
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        if (entity.equals((Object)this.cargo)) {
            double permeability = ((Quantity)this.getFeature((Featureable)this.transporter, OsmoticPermeability.class)).getValue().doubleValue();
            value = this.getSoluteDelta(membraneContainer) * permeability * membraneContainer.getInnerMembraneLayerConcentration((ChemicalEntity)this.transporter).getValue().doubleValue() * 10000.0;
        } else {
            value = 0.0;
        }
        return new Delta(this, membraneContainer.getInnerPhaseSection(), entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)value, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    private double getSoluteDelta(MembraneContainer container) {
        double outerConcentration = 0.0;
        for (ChemicalEntity solute : this.solutes) {
            outerConcentration += container.getOuterPhaseConcentration(solute).getValue().doubleValue();
        }
        double innerConcentration = 0.0;
        for (ChemicalEntity solute : this.solutes) {
            innerConcentration += container.getInnerPhaseConcentration(solute).getValue().doubleValue();
        }
        return this.isInnerPhase(container) ? innerConcentration - outerConcentration : outerConcentration - innerConcentration;
    }

    private boolean isCargo() {
        return this.getCurrentChemicalEntity().equals((Object)this.cargo);
    }

    private boolean transporterInMembrane(MembraneContainer container) {
        return container.getAvailableConcentration(container.getInnerLayerSection(), (ChemicalEntity)this.transporter).getValue().doubleValue() != 0.0;
    }

    private boolean isOuterPhase(MembraneContainer container) {
        return this.getCurrentCellSection().equals(container.getOuterPhaseSection());
    }

    private boolean isInnerPhase(MembraneContainer container) {
        return this.getCurrentCellSection().equals(container.getInnerPhaseSection());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.transporter.getName() + ")";
    }
}

