/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.transport;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.features.permeability.MembranePermeability;
import de.bioforscher.singa.features.model.Featureable;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.NodeState;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.model.concentrations.MembraneContainer;
import de.bioforscher.singa.simulation.modules.model.AbstractNeighbourIndependentModule;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.quantity.Quantities;

public class MembraneDiffusion
extends AbstractNeighbourIndependentModule {
    private ChemicalEntity cargo;

    public MembraneDiffusion(Simulation simulation, ChemicalEntity cargo) {
        super(simulation);
        this.cargo = cargo;
        this.onlyApplyIf(node -> node.getState().equals((Object)NodeState.MEMBRANE));
        this.addDeltaFunction(this::calculateInnerPhaseDelta, this::onlyInnerPhase);
        this.addDeltaFunction(this::calculateOuterPhaseDelta, this::onlyOuterPhase);
    }

    private Delta calculateOuterPhaseDelta(ConcentrationContainer concentrationContainer) {
        double value;
        ChemicalEntity entity = this.getCurrentChemicalEntity();
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        if (entity.equals((Object)this.cargo)) {
            double permeability = ((Quantity)this.getFeature((Featureable)this.cargo, MembranePermeability.class)).getValue().doubleValue();
            value = this.getCargoDelta(membraneContainer) * permeability;
        } else {
            value = 0.0;
        }
        return new Delta(this, membraneContainer.getOuterPhaseSection(), entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)value, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    private Delta calculateInnerPhaseDelta(ConcentrationContainer concentrationContainer) {
        double value;
        ChemicalEntity entity = this.getCurrentChemicalEntity();
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        if (entity.equals((Object)this.cargo)) {
            double permeability = ((Quantity)this.getFeature((Featureable)this.cargo, MembranePermeability.class)).getValue().doubleValue();
            value = this.getCargoDelta(membraneContainer) * permeability;
        } else {
            value = 0.0;
        }
        return new Delta(this, membraneContainer.getInnerPhaseSection(), entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)value, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    private double getCargoDelta(MembraneContainer container) {
        double outerConcentration = container.getOuterPhaseConcentration(this.cargo).getValue().doubleValue();
        double innerConcentration = container.getInnerPhaseConcentration(this.cargo).getValue().doubleValue();
        return this.isInnerPhase(container) ? outerConcentration - innerConcentration : innerConcentration - outerConcentration;
    }

    private boolean onlyOuterPhase(ConcentrationContainer concentrationContainer) {
        MembraneContainer container = (MembraneContainer)concentrationContainer;
        return this.isOuterPhase(container) && this.isCargo();
    }

    private boolean onlyInnerPhase(ConcentrationContainer concentrationContainer) {
        MembraneContainer container = (MembraneContainer)concentrationContainer;
        return this.isInnerPhase(container) && this.isCargo();
    }

    private boolean isOuterPhase(MembraneContainer container) {
        return this.getCurrentCellSection().equals(container.getOuterPhaseSection());
    }

    private boolean isInnerPhase(MembraneContainer container) {
        return this.getCurrentCellSection().equals(container.getInnerPhaseSection());
    }

    private boolean isCargo() {
        return this.getCurrentChemicalEntity().equals((Object)this.cargo);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.cargo.getName() + ")";
    }
}

