/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.transport;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.Diffusivity;
import de.bioforscher.singa.features.model.Featureable;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.modules.model.AbstractNeighbourDependentModule;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.quantity.Quantities;

public class FreeDiffusion
extends AbstractNeighbourDependentModule {
    private Set<ChemicalEntity> chemicalEntities;

    public FreeDiffusion(Simulation simulation, Set<ChemicalEntity> chemicalEntities) {
        super(simulation);
        this.chemicalEntities = chemicalEntities;
        this.addDeltaFunction(this::calculateDelta, this::onlyForReferencedEntities);
    }

    private boolean onlyForReferencedEntities(ConcentrationContainer concentrationContainer) {
        return this.chemicalEntities.contains(this.currentChemicalEntity);
    }

    private Delta calculateDelta(ConcentrationContainer concentrationContainer) {
        ChemicalEntity currentChemicalEntity = this.getCurrentChemicalEntity();
        CellSection currentCellSection = this.getCurrentCellSection();
        double currentConcentration = concentrationContainer.getAvailableConcentration(currentCellSection, currentChemicalEntity).getValue().doubleValue();
        int numberOfNeighbors = 0;
        double concentration = 0.0;
        for (AutomatonNode neighbour : this.getCurrentNode().getNeighbours()) {
            Quantity<MolarConcentration> availableConcentration = neighbour.getAvailableConcentration(currentChemicalEntity, currentCellSection);
            if (availableConcentration == null) continue;
            concentration += availableConcentration.getValue().doubleValue();
            ++numberOfNeighbors;
        }
        double enteringConcentration = concentration * ((Quantity)this.getFeature((Featureable)currentChemicalEntity, Diffusivity.class)).getValue().doubleValue();
        double leavingConcentration = (double)numberOfNeighbors * ((Quantity)this.getFeature((Featureable)currentChemicalEntity, Diffusivity.class)).getValue().doubleValue() * currentConcentration;
        double delta = enteringConcentration - leavingConcentration;
        return new Delta(this, currentCellSection, currentChemicalEntity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)delta, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

