/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.transport;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.model.Featureable;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.features.permeability.MembraneEntry;
import de.bioforscher.singa.simulation.features.permeability.MembraneExit;
import de.bioforscher.singa.simulation.features.permeability.MembraneFlipFlop;
import de.bioforscher.singa.simulation.model.compartments.NodeState;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.model.concentrations.MembraneContainer;
import de.bioforscher.singa.simulation.modules.model.AbstractNeighbourIndependentModule;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.quantity.Quantities;

public class FlipFlopMembraneTransport
extends AbstractNeighbourIndependentModule {
    public FlipFlopMembraneTransport(Simulation simulation) {
        super(simulation);
        this.onlyApplyIf(node -> node.getState().equals((Object)NodeState.MEMBRANE));
        this.addDeltaFunction(this::calculateOuterPhaseDelta, this::onlyOuterPhase);
        this.addDeltaFunction(this::calculateOuterLayerDelta, this::onlyOuterLayer);
        this.addDeltaFunction(this::calculateInnerLayerDelta, this::onlyInnerLayer);
        this.addDeltaFunction(this::calculateInnerPhaseDelta, this::onlyInnerPhase);
    }

    private boolean onlyOuterPhase(ConcentrationContainer concentrationContainer) {
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        return this.getCurrentCellSection().equals(membraneContainer.getOuterPhaseSection());
    }

    private Delta calculateOuterPhaseDelta(ConcentrationContainer concentrationContainer) {
        ChemicalEntity entity = this.getCurrentChemicalEntity();
        Quantity kIn = (Quantity)this.getFeature((Featureable)entity, MembraneEntry.class);
        Quantity kOut = (Quantity)this.getFeature((Featureable)entity, MembraneExit.class);
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        double value = -kIn.getValue().doubleValue() * membraneContainer.getOuterPhaseConcentration(entity).getValue().doubleValue() + kOut.getValue().doubleValue() * membraneContainer.getOuterMembraneLayerConcentration(entity).getValue().doubleValue();
        return new Delta(this, membraneContainer.getOuterPhaseSection(), entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)value, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    private boolean onlyOuterLayer(ConcentrationContainer concentrationContainer) {
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        return this.getCurrentCellSection().equals(membraneContainer.getOuterLayerSection());
    }

    private Delta calculateOuterLayerDelta(ConcentrationContainer concentrationContainer) {
        ChemicalEntity entity = this.getCurrentChemicalEntity();
        Quantity kIn = (Quantity)this.getFeature((Featureable)entity, MembraneEntry.class);
        Quantity kOut = (Quantity)this.getFeature((Featureable)entity, MembraneExit.class);
        Quantity kFlip = (Quantity)this.getFeature((Featureable)entity, MembraneFlipFlop.class);
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        double value = kIn.getValue().doubleValue() * membraneContainer.getOuterPhaseConcentration(entity).getValue().doubleValue() - (kOut.getValue().doubleValue() + kFlip.getValue().doubleValue()) * membraneContainer.getOuterMembraneLayerConcentration(entity).getValue().doubleValue() + kFlip.getValue().doubleValue() * membraneContainer.getInnerMembraneLayerConcentration(entity).getValue().doubleValue();
        return new Delta(this, membraneContainer.getOuterLayerSection(), entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)value, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    private boolean onlyInnerLayer(ConcentrationContainer concentrationContainer) {
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        return this.getCurrentCellSection().equals(membraneContainer.getInnerLayerSection());
    }

    private Delta calculateInnerLayerDelta(ConcentrationContainer concentrationContainer) {
        ChemicalEntity entity = this.getCurrentChemicalEntity();
        Quantity kIn = (Quantity)this.getFeature((Featureable)entity, MembraneEntry.class);
        Quantity kOut = (Quantity)this.getFeature((Featureable)entity, MembraneExit.class);
        Quantity kFlip = (Quantity)this.getFeature((Featureable)entity, MembraneFlipFlop.class);
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        double value = kIn.getValue().doubleValue() * membraneContainer.getInnerPhaseConcentration(entity).getValue().doubleValue() - (kOut.getValue().doubleValue() + kFlip.getValue().doubleValue()) * membraneContainer.getInnerMembraneLayerConcentration(entity).getValue().doubleValue() + kFlip.getValue().doubleValue() * membraneContainer.getOuterMembraneLayerConcentration(entity).getValue().doubleValue();
        return new Delta(this, membraneContainer.getInnerLayerSection(), entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)value, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    private boolean onlyInnerPhase(ConcentrationContainer concentrationContainer) {
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        return this.getCurrentCellSection().equals(membraneContainer.getInnerPhaseSection());
    }

    private Delta calculateInnerPhaseDelta(ConcentrationContainer concentrationContainer) {
        ChemicalEntity entity = this.getCurrentChemicalEntity();
        Quantity kIn = (Quantity)this.getFeature((Featureable)entity, MembraneEntry.class);
        Quantity kOut = (Quantity)this.getFeature((Featureable)entity, MembraneExit.class);
        MembraneContainer membraneContainer = (MembraneContainer)concentrationContainer;
        double value = -kIn.getValue().doubleValue() * membraneContainer.getInnerPhaseConcentration(this.getCurrentChemicalEntity()).getValue().doubleValue() + kOut.getValue().doubleValue() * membraneContainer.getInnerMembraneLayerConcentration(this.getCurrentChemicalEntity()).getValue().doubleValue();
        return new Delta(this, membraneContainer.getInnerPhaseSection(), this.getCurrentChemicalEntity(), (Quantity<MolarConcentration>)Quantities.getQuantity((Number)value, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }
}

