/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.reactions.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.features.ChemistryFeatureContainer;
import de.bioforscher.singa.features.model.Feature;
import de.bioforscher.singa.features.model.FeatureContainer;
import de.bioforscher.singa.features.model.Featureable;
import de.bioforscher.singa.features.model.ScalableFeature;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.modules.model.AbstractSectionSpecificModule;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import de.bioforscher.singa.simulation.modules.reactions.model.Reactant;
import de.bioforscher.singa.simulation.modules.reactions.model.ReactantRole;
import de.bioforscher.singa.simulation.modules.reactions.model.StoichiometricReactant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.quantity.Quantities;

public abstract class Reaction
extends AbstractSectionSpecificModule
implements Featureable {
    protected final Set<Class<? extends Feature>> availableFeatures = new HashSet<Class<? extends Feature>>();
    private List<StoichiometricReactant> stoichiometricReactants;
    private boolean elementary;
    private FeatureContainer features;

    public Reaction(Simulation simulation) {
        super(simulation);
        this.initialize();
    }

    private void initialize() {
        this.stoichiometricReactants = new ArrayList<StoichiometricReactant>();
        this.features = new ChemistryFeatureContainer();
    }

    public List<StoichiometricReactant> getStoichiometricReactants() {
        return this.stoichiometricReactants;
    }

    public void setStoichiometricReactants(List<StoichiometricReactant> stoichiometricReactants) {
        this.stoichiometricReactants = stoichiometricReactants;
    }

    public List<ChemicalEntity> getSubstrates() {
        return this.stoichiometricReactants.stream().filter(StoichiometricReactant::isSubstrate).map(Reactant::getEntity).collect(Collectors.toList());
    }

    public List<ChemicalEntity> getProducts() {
        return this.stoichiometricReactants.stream().filter(StoichiometricReactant::isProduct).map(Reactant::getEntity).collect(Collectors.toList());
    }

    protected double determineConcentration(ConcentrationContainer concentrationContainer, ReactantRole role) {
        double product = 1.0;
        for (StoichiometricReactant reactant : this.getStoichiometricReactants()) {
            if (reactant.getRole() != role) continue;
            if (this.isElementary()) {
                product *= concentrationContainer.getAvailableConcentration(this.getCurrentCellSection(), reactant.getEntity()).getValue().doubleValue();
                continue;
            }
            product *= Math.pow(concentrationContainer.getAvailableConcentration(this.getCurrentCellSection(), reactant.getEntity()).getValue().doubleValue(), reactant.getReactionOrder());
        }
        return product;
    }

    public List<Delta> calculateDeltas(ConcentrationContainer concentrationContainer) {
        ArrayList<Delta> deltas = new ArrayList<Delta>();
        double velocity = this.calculateVelocity(concentrationContainer);
        for (StoichiometricReactant reactant : this.getStoichiometricReactants()) {
            double deltaValue = reactant.isSubstrate() ? -velocity * reactant.getStoichiometricNumber() : velocity * reactant.getStoichiometricNumber();
            deltas.add(new Delta(this, this.getCurrentCellSection(), reactant.getEntity(), (Quantity<MolarConcentration>)Quantities.getQuantity((Number)deltaValue, (Unit)EnvironmentalParameters.getTransformedMolarConcentration())));
        }
        return deltas;
    }

    public abstract double calculateVelocity(ConcentrationContainer var1);

    public boolean isElementary() {
        return this.elementary;
    }

    public void setElementary(boolean elementary) {
        this.elementary = elementary;
    }

    public String getDisplayString() {
        String substrates = this.stoichiometricReactants.stream().filter(StoichiometricReactant::isSubstrate).map(substrate -> (substrate.getStoichiometricNumber() > 1.0 ? Double.valueOf(substrate.getStoichiometricNumber()) : "") + " " + substrate.getEntity().getIdentifier()).collect(Collectors.joining(" +"));
        String products = this.stoichiometricReactants.stream().filter(StoichiometricReactant::isProduct).map(product -> (product.getStoichiometricNumber() > 1.0 ? Double.valueOf(product.getStoichiometricNumber()) : "") + " " + product.getEntity().getIdentifier()).collect(Collectors.joining(" +"));
        return substrates + " \u27f6" + products;
    }

    public Collection<Feature<?>> getFeatures() {
        return this.features.getAllFeatures();
    }

    public <FeatureType extends Feature> FeatureType getFeature(Class<FeatureType> featureTypeClass) {
        return (FeatureType)this.features.getFeature(featureTypeClass);
    }

    protected <FeatureContent> FeatureContent getScaledFeature(Class<? extends ScalableFeature<FeatureContent>> featureClass) {
        ScalableFeature<FeatureContent> feature = this.getFeature(featureClass);
        if (this.halfTime) {
            return (FeatureContent)feature.getHalfScaledQuantity();
        }
        return (FeatureContent)feature.getScaledQuantity();
    }

    public <FeatureType extends Feature> void setFeature(Class<FeatureType> featureTypeClass) {
        this.features.setFeature(featureTypeClass, (Featureable)this);
    }

    public <FeatureType extends Feature> void setFeature(FeatureType feature) {
        this.features.setFeature(feature);
    }

    public <FeatureType extends Feature> boolean hasFeature(Class<FeatureType> featureTypeClass) {
        return this.features.hasFeature(featureTypeClass);
    }

    public Set<Class<? extends Feature>> getAvailableFeatures() {
        return this.availableFeatures;
    }
}

