/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.reactions.implementations;

import de.bioforscher.singa.chemistry.descriptive.features.reactions.RateConstant;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import de.bioforscher.singa.simulation.modules.reactions.model.ReactantRole;
import de.bioforscher.singa.simulation.modules.reactions.model.Reaction;
import javax.measure.Quantity;
import javax.measure.quantity.Frequency;

public class NthOrderReaction
extends Reaction {
    public NthOrderReaction(Simulation simulation, Quantity<Frequency> rateConstant) {
        super(simulation);
        this.availableFeatures.add(RateConstant.class);
        this.setFeature(new RateConstant(rateConstant, FeatureOrigin.MANUALLY_ANNOTATED));
        this.addDeltaFunction(this::calculateDeltas, bioNode -> true);
    }

    @Override
    public double calculateVelocity(ConcentrationContainer concentrationContainer) {
        Quantity reactionRate = (Quantity)this.getScaledFeature(RateConstant.class);
        double concentration = this.determineConcentration(concentrationContainer, ReactantRole.DECREASING);
        return concentration * reactionRate.getValue().doubleValue();
    }
}

