/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.reactions.implementations;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.entities.Enzyme;
import de.bioforscher.singa.chemistry.descriptive.features.reactions.MichaelisConstant;
import de.bioforscher.singa.chemistry.descriptive.features.reactions.TurnoverNumber;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import de.bioforscher.singa.simulation.modules.reactions.model.Reaction;
import javax.measure.Quantity;

public class MichaelisMentenReaction
extends Reaction {
    private final Enzyme enzyme;

    public MichaelisMentenReaction(Simulation simulation, Enzyme enzyme) {
        super(simulation);
        this.enzyme = enzyme;
        this.availableFeatures.add(TurnoverNumber.class);
        this.availableFeatures.add(MichaelisConstant.class);
        this.setFeature(enzyme.getFeature(TurnoverNumber.class));
        this.setFeature(enzyme.getFeature(MichaelisConstant.class));
        this.addDeltaFunction(this::calculateDeltas, bioNode -> true);
    }

    @Override
    public double calculateVelocity(ConcentrationContainer concentrationContainer) {
        Quantity kCat = (Quantity)this.getScaledFeature(TurnoverNumber.class);
        Quantity km = (Quantity)this.getFeature(MichaelisConstant.class).getFeatureContent();
        double substrate = concentrationContainer.getAvailableConcentration(this.getCurrentCellSection(), (ChemicalEntity)this.enzyme.getSubstrates().iterator().next()).getValue().doubleValue();
        double enzyme = concentrationContainer.getAvailableConcentration(this.getCurrentCellSection(), (ChemicalEntity)this.enzyme).getValue().doubleValue();
        return kCat.getValue().doubleValue() * enzyme * substrate / (km.getValue().doubleValue() + substrate);
    }
}

