/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.reactions.implementations;

import de.bioforscher.singa.chemistry.descriptive.features.reactions.BackwardsRateConstant;
import de.bioforscher.singa.chemistry.descriptive.features.reactions.ForwardsRateConstant;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import de.bioforscher.singa.simulation.modules.reactions.model.ReactantRole;
import de.bioforscher.singa.simulation.modules.reactions.model.Reaction;
import javax.measure.Quantity;
import javax.measure.quantity.Frequency;

public class EquilibriumReaction
extends Reaction {
    public EquilibriumReaction(Simulation simulation, Quantity<Frequency> forwardsRateConstant, Quantity<Frequency> backwardsRateConstant) {
        super(simulation);
        this.availableFeatures.add(ForwardsRateConstant.class);
        this.availableFeatures.add(BackwardsRateConstant.class);
        this.setFeature(new ForwardsRateConstant(forwardsRateConstant, FeatureOrigin.MANUALLY_ANNOTATED));
        this.setFeature(new BackwardsRateConstant(backwardsRateConstant, FeatureOrigin.MANUALLY_ANNOTATED));
        this.addDeltaFunction(this::calculateDeltas, bioNode -> true);
    }

    @Override
    public double calculateVelocity(ConcentrationContainer concentrationContainer) {
        Quantity forwardsRateConstant = (Quantity)this.getScaledFeature(ForwardsRateConstant.class);
        Quantity backwardsRateConstant = (Quantity)this.getScaledFeature(BackwardsRateConstant.class);
        double substrateConcentration = this.determineConcentration(concentrationContainer, ReactantRole.DECREASING);
        double productConcentration = this.determineConcentration(concentrationContainer, ReactantRole.INCREASING);
        return substrateConcentration * forwardsRateConstant.getValue().doubleValue() - productConcentration * backwardsRateConstant.getValue().doubleValue();
    }
}

