/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.reactions.implementations;

import de.bioforscher.singa.simulation.features.scale.AppliedScale;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import de.bioforscher.singa.simulation.modules.reactions.implementations.DynamicKineticLaw;
import de.bioforscher.singa.simulation.modules.reactions.model.CatalyticReactant;
import de.bioforscher.singa.simulation.modules.reactions.model.Reaction;
import java.util.ArrayList;
import java.util.List;

public class DynamicReaction
extends Reaction {
    private List<CatalyticReactant> catalyticReactants;
    private DynamicKineticLaw kineticLaw;

    public DynamicReaction(Simulation simulation, DynamicKineticLaw kineticLaw) {
        super(simulation);
        this.initialize(kineticLaw);
    }

    private void initialize(DynamicKineticLaw kineticLaw) {
        this.kineticLaw = kineticLaw;
        this.catalyticReactants = new ArrayList<CatalyticReactant>();
        this.availableFeatures.add(AppliedScale.class);
        this.setFeature(new AppliedScale());
        this.addDeltaFunction(this::calculateDeltas, bioNode -> true);
    }

    public DynamicKineticLaw getKineticLaw() {
        return this.kineticLaw;
    }

    public void setKineticLaw(DynamicKineticLaw kineticLaw) {
        this.kineticLaw = kineticLaw;
    }

    public List<CatalyticReactant> getCatalyticReactants() {
        return this.catalyticReactants;
    }

    public void setCatalyticReactants(List<CatalyticReactant> catalyticReactants) {
        this.catalyticReactants = catalyticReactants;
    }

    @Override
    public double calculateVelocity(ConcentrationContainer concentrationContainer) {
        this.kineticLaw.setCurrentCellSection(this.getCurrentCellSection());
        this.kineticLaw.setAppliedScale((Double)this.getScaledFeature(AppliedScale.class));
        return this.kineticLaw.calculateVelocity(concentrationContainer);
    }
}

