/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.reactions.implementations;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.model.parameters.SimulationParameter;
import de.bioforscher.singa.simulation.model.rules.AppliedExpression;
import de.bioforscher.singa.simulation.modules.reactions.model.KineticLaw;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Quantity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicKineticLaw
implements KineticLaw {
    private static final Logger logger = LoggerFactory.getLogger(DynamicKineticLaw.class);
    private final AppliedExpression expression;
    private final Map<ChemicalEntity, String> entityReference;
    private CellSection currentCellSection;
    private Double appliedScale = 1.0;

    public DynamicKineticLaw(AppliedExpression expression) {
        this.expression = expression;
        this.entityReference = new HashMap<ChemicalEntity, String>();
    }

    public AppliedExpression getExpression() {
        return this.expression;
    }

    public void referenceChemicalEntityToParameter(String parameterIdentifier, ChemicalEntity entity) {
        this.entityReference.put(entity, parameterIdentifier);
        this.expression.setParameter(new SimulationParameter(parameterIdentifier, EnvironmentalParameters.emptyConcentration()));
    }

    public Map<ChemicalEntity, String> getEntityReference() {
        return this.entityReference;
    }

    public double getAppliedScale() {
        return this.appliedScale;
    }

    public void setAppliedScale(Double appliedScale) {
        this.appliedScale = appliedScale;
    }

    public CellSection getCurrentCellSection() {
        return this.currentCellSection;
    }

    public void setCurrentCellSection(CellSection currentCellSection) {
        this.currentCellSection = currentCellSection;
    }

    @Override
    public double calculateVelocity(ConcentrationContainer concentrationContainer) {
        for (Map.Entry<ChemicalEntity, String> entry : this.entityReference.entrySet()) {
            Quantity<MolarConcentration> concentration = concentrationContainer.getAvailableConcentration(this.currentCellSection, entry.getKey());
            String parameterName = this.entityReference.get(entry.getKey());
            this.expression.acceptValue(parameterName, concentration.getValue().doubleValue());
        }
        return this.expression.evaluate().getValue().doubleValue() * this.appliedScale;
    }
}

