/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.model.Featureable;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.modules.model.LocalError;
import de.bioforscher.singa.simulation.modules.model.Module;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import javax.measure.Quantity;
import javax.measure.quantity.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStepHarmonizer {
    private static final Logger logger = LoggerFactory.getLogger(TimeStepHarmonizer.class);
    private final Simulation simulation;
    private double epsilon = 0.01;
    private Quantity<Time> currentTimeStep;
    private Module criticalModule;
    private LocalError largestLocalError;
    private boolean timeStepChanged;

    public TimeStepHarmonizer(Simulation simulation) {
        EnvironmentalParameters.setTimeStep((Quantity)EnvironmentalParameters.getTimeStep());
        this.simulation = simulation;
        this.largestLocalError = LocalError.MINIMAL_EMPTY_ERROR;
        this.timeStepChanged = true;
    }

    public boolean step() {
        this.currentTimeStep = EnvironmentalParameters.getTimeStep();
        if (this.timeStepChanged) {
            this.rescaleParameters();
        }
        this.executeAllModules();
        do {
            this.optimizeTimeStep();
            if (!this.timeStepChanged) continue;
            for (AutomatonNode bioNode : this.simulation.getGraph().getNodes()) {
                bioNode.clearPotentialDeltas();
            }
            this.executeAllModules();
        } while (this.largestLocalError.getValue() > this.epsilon);
        this.finalizeDeltas();
        return this.timeStepChanged;
    }

    private void executeAllModules() {
        logger.debug("Calculating deltas and errors for all modules.");
        this.largestLocalError = LocalError.MINIMAL_EMPTY_ERROR;
        for (Module module : this.simulation.getModules()) {
            logger.trace("Calculating deltas for Module {}", (Object)module.toString());
            module.determineAllDeltas();
            LocalError largestLocalError = module.getLargestLocalError();
            module.resetLargestLocalError();
            this.examineLocalError(module, largestLocalError);
        }
    }

    private void finalizeDeltas() {
        for (AutomatonNode node : this.simulation.getGraph().getNodes()) {
            node.shiftDeltas();
        }
    }

    private void examineLocalError(Module module, LocalError localError) {
        if (this.largestLocalError.getValue() < localError.getValue()) {
            this.largestLocalError = localError;
            this.criticalModule = module;
        }
    }

    private void optimizeTimeStep() {
        double localError = this.largestLocalError.getValue();
        this.timeStepChanged = false;
        boolean errorIsTooLarge = this.tryToDecreaseTimeStep(this.largestLocalError.getValue());
        while (errorIsTooLarge) {
            this.currentTimeStep = EnvironmentalParameters.getTimeStep();
            localError = this.criticalModule.determineDeltasForNode(this.largestLocalError.getNode()).getValue();
            this.criticalModule.resetLargestLocalError();
            errorIsTooLarge = this.tryToDecreaseTimeStep(localError);
        }
        logger.debug("Optimized local error for {} was {} with time step of {}.", new Object[]{this.criticalModule, localError, EnvironmentalParameters.getTimeStep()});
    }

    public LocalError getLargestLocalError() {
        return this.largestLocalError;
    }

    public void rescaleParameters() {
        for (ChemicalEntity entity : this.simulation.getChemicalEntities()) {
            entity.scaleScalableFeatures();
        }
        for (Module module : this.simulation.getModules()) {
            if (!(module instanceof Featureable)) continue;
            ((Featureable)module).scaleScalableFeatures();
        }
    }

    public void increaseTimeStep() {
        EnvironmentalParameters.setTimeStep((Quantity)this.currentTimeStep.multiply((Number)1.2));
        logger.debug("Increasing time step to {}.", (Object)EnvironmentalParameters.getTimeStep());
        this.rescaleParameters();
        this.timeStepChanged = true;
    }

    public void decreaseTimeStep() {
        EnvironmentalParameters.setTimeStep((Quantity)this.currentTimeStep.multiply((Number)0.8));
        logger.debug("Decreasing time step to {}.", (Object)EnvironmentalParameters.getTimeStep());
        this.rescaleParameters();
        this.timeStepChanged = true;
    }

    private boolean tryToDecreaseTimeStep(double localError) {
        if (localError > this.epsilon) {
            this.decreaseTimeStep();
            return true;
        }
        return false;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }
}

