/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.simulation.modules.model.SimulationManager;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimulationSetup {
    private static final Logger logger = LoggerFactory.getLogger(SimulationManager.class);
    private Set<ChemicalEntity> chemicalEntities;

    public void initialize() {
        this.initializeEnvironmentalParameters();
        this.initializeChemicalEntities();
        this.initializeCompartments();
        this.initializeGraph();
        this.initializeConcentrations();
        this.initializeSimulation();
        this.initializeModules();
    }

    public void initializeEnvironmentalParameters() {
        logger.info("Initializing environmental parameters ...");
    }

    public void initializeChemicalEntities() {
        logger.info("Initializing chemical entities ...");
    }

    public void initializeCompartments() {
        logger.info("Initializing environmental parameters ...");
    }

    public void initializeGraph() {
        logger.info("Initializing cellular automaton graph ...");
    }

    public void initializeConcentrations() {
        logger.info("Initializing starting concentrations of chemical entities in graph ...");
    }

    public void initializeSimulation() {
        logger.info("Initializing simulation ...");
    }

    public void initializeModules() {
        logger.info("Initializing modules ...");
    }

    public void simulate() {
        logger.info("Starting simulation ...");
    }

    public void addToChemcialEntities(ChemicalEntity entity) {
        this.chemicalEntities.add(entity);
        logger.debug(entity.getStringForProtocol());
    }
}

