/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.core.events.UpdateEventListener;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.simulation.events.EpochUpdateWriter;
import de.bioforscher.singa.simulation.events.GraphEventEmitter;
import de.bioforscher.singa.simulation.events.GraphUpdatedEvent;
import de.bioforscher.singa.simulation.events.NodeEventEmitter;
import de.bioforscher.singa.simulation.events.NodeUpdatedEvent;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;

public class SimulationManager
extends Task<Simulation> {
    private static final Logger logger = LoggerFactory.getLogger(SimulationManager.class);
    private final Simulation simulation;
    private Predicate<Simulation> terminationCondition;
    private Predicate<Simulation> emitCondition;
    private NodeEventEmitter nodeEventEmitter;
    private GraphEventEmitter graphEventEmitter;
    private long nextTick = System.currentTimeMillis();
    private Quantity<Time> scheduledEmitTime = Quantities.getQuantity((Number)0.0, (Unit)EnvironmentalParameters.getTimeStep().getUnit());

    public SimulationManager(Simulation simulation) {
        logger.debug("Initializing simulation manager ...");
        this.simulation = simulation;
        this.nodeEventEmitter = new NodeEventEmitter();
        this.graphEventEmitter = new GraphEventEmitter();
        this.emitCondition = s -> true;
    }

    public void addNodeUpdateListener(UpdateEventListener<NodeUpdatedEvent> listener) {
        logger.info("Added {} to node update listeners.", (Object)listener.getClass().getSimpleName());
        this.nodeEventEmitter.addEventListener(listener);
    }

    public CopyOnWriteArrayList<UpdateEventListener<NodeUpdatedEvent>> getNodeListeners() {
        return this.nodeEventEmitter.getListeners();
    }

    public void addGraphUpdateListener(UpdateEventListener<GraphUpdatedEvent> listener) {
        logger.info("Added {} to graph update listeners.", (Object)listener.getClass().getSimpleName());
        this.graphEventEmitter.addEventListener(listener);
    }

    public void setTerminationCondition(Predicate<Simulation> terminationCondition) {
        this.terminationCondition = terminationCondition;
    }

    public void setSimulationTerminationToTime(Quantity<Time> time) {
        this.setTerminationCondition(s -> s.getElapsedTime().isLessThan(time));
    }

    public void setSimulationTerminationToEpochs(long epochs) {
        this.setTerminationCondition(s -> s.getEpoch() < epochs);
    }

    public void setUpdateEmissionCondition(Predicate<Simulation> emitCondition) {
        this.emitCondition = emitCondition;
    }

    public void setUpdateEmissionToFPS(int fps) {
        int skipTicks = 1000 / fps;
        this.emitCondition = s -> {
            long currentMillis = System.currentTimeMillis();
            if (currentMillis > this.nextTick) {
                this.nextTick = currentMillis + (long)skipTicks;
                return true;
            }
            return false;
        };
    }

    public void setUpdateEmissionToTimePassed(Quantity<Time> timePassed) {
        this.emitCondition = s -> {
            ComparableQuantity<Time> currentTime = s.getElapsedTime();
            if (currentTime.isGreaterThan(this.scheduledEmitTime)) {
                this.scheduledEmitTime = currentTime.add(timePassed);
                return true;
            }
            return false;
        };
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    protected Simulation call() {
        while (!this.isCancelled() && this.terminationCondition.test(this.simulation)) {
            if (this.emitCondition.test(this.simulation)) {
                logger.info("Emitting event after {} (epoch {}).", this.simulation.getElapsedTime(), (Object)this.simulation.getEpoch());
                this.graphEventEmitter.emitEvent(new GraphUpdatedEvent(this.simulation.getGraph()));
                for (AutomatonNode automatonNode : this.simulation.getObservedNodes()) {
                    this.nodeEventEmitter.emitEvent(new NodeUpdatedEvent((Quantity<Time>)this.simulation.getElapsedTime(), automatonNode));
                    logger.debug("Emitted next epoch event for node {}.", automatonNode.getIdentifier());
                }
            }
            this.simulation.nextEpoch();
        }
        return this.simulation;
    }

    protected void done() {
        try {
            logger.info("Simulation finished.");
            for (UpdateEventListener<NodeUpdatedEvent> nodeUpdatedEventUpdateEventListener : this.getNodeListeners()) {
                if (!(nodeUpdatedEventUpdateEventListener instanceof EpochUpdateWriter)) continue;
                ((EpochUpdateWriter)nodeUpdatedEventUpdateEventListener).closeWriters();
            }
            Platform.exit();
            if (!this.isCancelled()) {
                this.get();
            }
        }
        catch (ExecutionException e) {
            logger.error("Encountered an exception during simulation: " + e.getCause());
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

