/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.entities.Enzyme;
import de.bioforscher.singa.chemistry.descriptive.entities.Species;
import de.bioforscher.singa.chemistry.descriptive.features.databases.chebi.ChEBIParserService;
import de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem.PubChemParserService;
import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.Diffusivity;
import de.bioforscher.singa.chemistry.descriptive.features.reactions.MichaelisConstant;
import de.bioforscher.singa.chemistry.descriptive.features.reactions.TurnoverNumber;
import de.bioforscher.singa.features.model.Feature;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.features.units.UnitProvider;
import de.bioforscher.singa.mathematics.graphs.grid.GridCoordinateConverter;
import de.bioforscher.singa.mathematics.graphs.model.Graphs;
import de.bioforscher.singa.mathematics.topology.grids.rectangular.RectangularCoordinate;
import de.bioforscher.singa.simulation.features.permeability.MembraneEntry;
import de.bioforscher.singa.simulation.features.permeability.MembraneExit;
import de.bioforscher.singa.simulation.features.permeability.MembraneFlipFlop;
import de.bioforscher.singa.simulation.model.compartments.EnclosedCompartment;
import de.bioforscher.singa.simulation.model.compartments.Membrane;
import de.bioforscher.singa.simulation.model.concentrations.MembraneContainer;
import de.bioforscher.singa.simulation.model.graphs.AutomatonGraph;
import de.bioforscher.singa.simulation.model.graphs.AutomatonGraphs;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.model.rules.AssignmentRule;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import de.bioforscher.singa.simulation.modules.reactions.implementations.EquilibriumReaction;
import de.bioforscher.singa.simulation.modules.reactions.implementations.MichaelisMentenReaction;
import de.bioforscher.singa.simulation.modules.reactions.implementations.NthOrderReaction;
import de.bioforscher.singa.simulation.modules.reactions.model.ReactantRole;
import de.bioforscher.singa.simulation.modules.reactions.model.StoichiometricReactant;
import de.bioforscher.singa.simulation.modules.transport.FlipFlopMembraneTransport;
import de.bioforscher.singa.simulation.modules.transport.FreeDiffusion;
import de.bioforscher.singa.simulation.parser.sbml.BioModelsParserService;
import de.bioforscher.singa.simulation.parser.sbml.SBMLParser;
import de.bioforscher.singa.structure.features.molarmass.MolarMass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.Units;

public class SimulationExamples {
    private static final Logger logger = LoggerFactory.getLogger(SimulationExamples.class);

    public static Simulation createDecompositionReactionExample() {
        EnvironmentalParameters.setTimeStep((Quantity)Quantities.getQuantity((Number)10.0, (Unit)MetricPrefix.MILLI((Unit)Units.SECOND)));
        Simulation simulation = new Simulation();
        Species dinitrogenPentaoxide = ChEBIParserService.parse((String)"CHEBI:29802");
        Species nitrogenDioxide = ChEBIParserService.parse((String)"CHEBI:33101");
        Species oxygen = ChEBIParserService.parse((String)"CHEBI:15379");
        AutomatonGraph graph = AutomatonGraphs.singularGraph();
        graph.initializeSpeciesWithConcentration((ChemicalEntity)dinitrogenPentaoxide, 0.02);
        graph.initializeSpeciesWithConcentration((ChemicalEntity)nitrogenDioxide, 0.0);
        graph.initializeSpeciesWithConcentration((ChemicalEntity)oxygen, 0.0);
        NthOrderReaction reaction = new NthOrderReaction(simulation, (Quantity<Frequency>)Quantities.getQuantity((Number)0.07, (Unit)TurnoverNumber.PER_SECOND));
        reaction.setElementary(true);
        reaction.getStoichiometricReactants().addAll(Arrays.asList(new StoichiometricReactant((ChemicalEntity)dinitrogenPentaoxide, ReactantRole.DECREASING, 2.0), new StoichiometricReactant((ChemicalEntity)nitrogenDioxide, ReactantRole.INCREASING, 4.0), new StoichiometricReactant((ChemicalEntity)oxygen, ReactantRole.INCREASING)));
        simulation.setGraph(graph);
        simulation.getModules().add(reaction);
        return simulation;
    }

    public static Simulation createSynthesisReactionExample() {
        EnvironmentalParameters.setTimeStep((Quantity)Quantities.getQuantity((Number)1.0, (Unit)Units.SECOND));
        Simulation simulation = new Simulation();
        Species butadiene = ChEBIParserService.parse((String)"CHEBI:39478");
        Species octatriene = ChEBIParserService.parse((String)"CHEBI:77504");
        AutomatonGraph graph = AutomatonGraphs.singularGraph();
        graph.initializeSpeciesWithConcentration((ChemicalEntity)butadiene, 0.02);
        graph.initializeSpeciesWithConcentration((ChemicalEntity)octatriene, 0.0);
        NthOrderReaction reaction = new NthOrderReaction(simulation, (Quantity<Frequency>)Quantities.getQuantity((Number)0.614, (Unit)TurnoverNumber.PER_SECOND));
        reaction.setElementary(false);
        reaction.getStoichiometricReactants().addAll(Arrays.asList(new StoichiometricReactant((ChemicalEntity)butadiene, ReactantRole.DECREASING, 2.0, 2.0), new StoichiometricReactant((ChemicalEntity)octatriene, ReactantRole.INCREASING)));
        simulation.setGraph(graph);
        simulation.getModules().add(reaction);
        return simulation;
    }

    public static Simulation createEquilibriumReactionExample() {
        EnvironmentalParameters.setTimeStep((Quantity)Quantities.getQuantity((Number)10.0, (Unit)MetricPrefix.MILLI((Unit)Units.SECOND)));
        Simulation simulation = new Simulation();
        Species speciesA = (Species)((Species.Builder)new Species.Builder("CHEBI:00001").name("A")).build();
        Species speciesB = (Species)((Species.Builder)new Species.Builder("CHEBI:00002").name("B")).build();
        AutomatonGraph graph = AutomatonGraphs.singularGraph();
        graph.initializeSpeciesWithConcentration((ChemicalEntity)speciesA, 1.0);
        graph.initializeSpeciesWithConcentration((ChemicalEntity)speciesB, 0.0);
        EquilibriumReaction reaction = new EquilibriumReaction(simulation, (Quantity<Frequency>)Quantities.getQuantity((Number)10, (Unit)TurnoverNumber.PER_SECOND), (Quantity<Frequency>)Quantities.getQuantity((Number)10, (Unit)TurnoverNumber.PER_SECOND));
        reaction.setElementary(true);
        reaction.getStoichiometricReactants().addAll(Arrays.asList(new StoichiometricReactant((ChemicalEntity)speciesA, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)speciesB, ReactantRole.INCREASING)));
        simulation.setGraph(graph);
        simulation.getModules().add(reaction);
        return simulation;
    }

    public static Simulation createMichaelisMentenReactionExample() {
        EnvironmentalParameters.setTimeStep((Quantity)Quantities.getQuantity((Number)1.0, (Unit)MetricPrefix.MILLI((Unit)Units.SECOND)));
        Simulation simulation = new Simulation();
        Species fructosePhosphate = ChEBIParserService.parse((String)"CHEBI:18105");
        Species glyceronePhosphate = ChEBIParserService.parse((String)"CHEBI:16108");
        Species glyceraldehyde = ChEBIParserService.parse((String)"CHEBI:17378");
        Enzyme aldolase = (Enzyme)((Enzyme.Builder)((Enzyme.Builder)((Enzyme.Builder)((Enzyme.Builder)new Enzyme.Builder("P07752").name("Fructose-bisphosphate aldolase")).addSubstrate(fructosePhosphate).assignFeature((Feature)new MolarMass(82142.0, FeatureOrigin.MANUALLY_ANNOTATED))).assignFeature((Feature)new MichaelisConstant((Quantity)Quantities.getQuantity((Number)0.009, (Unit)UnitProvider.MOLE_PER_LITRE).to(EnvironmentalParameters.getTransformedMolarConcentration()), FeatureOrigin.MANUALLY_ANNOTATED))).assignFeature((Feature)new TurnoverNumber((Quantity)Quantities.getQuantity((Number)76, (Unit)TurnoverNumber.PER_MINUTE), FeatureOrigin.MANUALLY_ANNOTATED))).build();
        AutomatonGraph graph = AutomatonGraphs.singularGraph();
        graph.initializeSpeciesWithConcentration((ChemicalEntity)fructosePhosphate, 0.1);
        graph.initializeSpeciesWithConcentration((ChemicalEntity)aldolase, 0.2);
        graph.initializeSpeciesWithConcentration((ChemicalEntity)glyceronePhosphate, 0.0);
        graph.initializeSpeciesWithConcentration((ChemicalEntity)glyceraldehyde, 0.0);
        MichaelisMentenReaction reaction = new MichaelisMentenReaction(simulation, aldolase);
        reaction.getStoichiometricReactants().addAll(Arrays.asList(new StoichiometricReactant((ChemicalEntity)fructosePhosphate, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)glyceronePhosphate, ReactantRole.INCREASING), new StoichiometricReactant((ChemicalEntity)glyceraldehyde, ReactantRole.INCREASING)));
        simulation.setGraph(graph);
        simulation.getModules().add(reaction);
        return simulation;
    }

    public static Simulation createDiffusionModuleExample(int numberOfNodes, Quantity<Time> timeStep) {
        EnvironmentalParameters.setTimeStep(timeStep);
        EnvironmentalParameters.setNodeSpacingToDiameter((Quantity)Quantities.getQuantity((Number)2500.0, (Unit)MetricPrefix.NANO((Unit)Units.METRE)), (int)numberOfNodes);
        Species methanol = ChEBIParserService.parse((String)"CHEBI:17790");
        methanol.setFeature(Diffusivity.class);
        Species ethyleneGlycol = ChEBIParserService.parse((String)"CHEBI:30742");
        ethyleneGlycol.setFeature(Diffusivity.class);
        Species valine = ChEBIParserService.parse((String)"CHEBI:27266");
        valine.setFeature(Diffusivity.class);
        Species sucrose = ChEBIParserService.parse((String)"CHEBI:17992");
        sucrose.setFeature(Diffusivity.class);
        AutomatonGraph graph = AutomatonGraphs.useStructureFrom(Graphs.buildGridGraph((int)numberOfNodes, (int)numberOfNodes));
        for (AutomatonNode node : graph.getNodes()) {
            if (((RectangularCoordinate)node.getIdentifier()).getColumn() >= graph.getNumberOfColumns() / 2) continue;
            node.setConcentration((ChemicalEntity)methanol, 1.0);
            node.setConcentration((ChemicalEntity)ethyleneGlycol, 1.0);
            node.setConcentration((ChemicalEntity)valine, 1.0);
            node.setConcentration((ChemicalEntity)sucrose, 1.0);
        }
        Simulation simulation = new Simulation();
        simulation.setGraph(graph);
        simulation.getChemicalEntities().addAll(Arrays.asList(methanol, ethyleneGlycol, valine, sucrose));
        simulation.getModules().add(new FreeDiffusion(simulation, simulation.getChemicalEntities()));
        return simulation;
    }

    public static Simulation createIodineMultiReactionExample() {
        logger.debug("Adjusting time step size ... ");
        EnvironmentalParameters.setTimeStep((Quantity)Quantities.getQuantity((Number)1.0, (Unit)MetricPrefix.MILLI((Unit)Units.SECOND)));
        Simulation simulation = new Simulation();
        logger.info("Setting up the passive membrane diffusion example ...");
        logger.debug("Importing species ...");
        Species hydron = ChEBIParserService.parse((String)"CHEBI:15378");
        Species iodide = ChEBIParserService.parse((String)"CHEBI:16382");
        Species diiodine = ChEBIParserService.parse((String)"CHEBI:17606");
        Species water = ChEBIParserService.parse((String)"CHEBI:15377");
        Species hia = ChEBIParserService.parse((String)"CHEBI:29231");
        Species ia = ChEBIParserService.parse((String)"CHEBI:29229");
        Species iodineDioxid = ChEBIParserService.parse((String)"CHEBI:29901");
        Species iodate = ChEBIParserService.parse((String)"CHEBI:29226");
        logger.debug("Setting up example graph ...");
        AutomatonGraph graph = AutomatonGraphs.singularGraph();
        logger.debug("Initializing starting concentrations of species and node states in graph ...");
        ((AutomatonNode)graph.getNode(0, 0)).setConcentrations(0.05, new ChemicalEntity[]{hydron, iodide, diiodine, water, hia, ia, iodineDioxid, iodate});
        logger.debug("Composing simulation ... ");
        NthOrderReaction firstReaction = new NthOrderReaction(simulation, (Quantity<Frequency>)Quantities.getQuantity((Number)1430.0, (Unit)TurnoverNumber.PER_SECOND));
        firstReaction.setElementary(true);
        firstReaction.getStoichiometricReactants().addAll(Arrays.asList(new StoichiometricReactant((ChemicalEntity)hydron, ReactantRole.DECREASING, 2.0), new StoichiometricReactant((ChemicalEntity)iodide, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)iodate, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)hia, ReactantRole.INCREASING), new StoichiometricReactant((ChemicalEntity)ia, ReactantRole.INCREASING)));
        NthOrderReaction secondReaction = new NthOrderReaction(simulation, (Quantity<Frequency>)Quantities.getQuantity((Number)20000.0, (Unit)TurnoverNumber.PER_SECOND));
        secondReaction.setElementary(true);
        secondReaction.getStoichiometricReactants().addAll(Arrays.asList(new StoichiometricReactant((ChemicalEntity)hydron, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)ia, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)iodide, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)hia, ReactantRole.INCREASING)));
        EquilibriumReaction thirdReaction = new EquilibriumReaction(simulation, (Quantity<Frequency>)Quantities.getQuantity((Number)31000.0, (Unit)TurnoverNumber.PER_SECOND), (Quantity<Frequency>)Quantities.getQuantity((Number)2.2, (Unit)TurnoverNumber.PER_SECOND));
        thirdReaction.setElementary(true);
        thirdReaction.getStoichiometricReactants().addAll(Arrays.asList(new StoichiometricReactant((ChemicalEntity)hia, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)iodide, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)hydron, ReactantRole.DECREASING), new StoichiometricReactant((ChemicalEntity)diiodine, ReactantRole.INCREASING), new StoichiometricReactant((ChemicalEntity)water, ReactantRole.INCREASING)));
        simulation.getModules().addAll(Arrays.asList(firstReaction, secondReaction, thirdReaction));
        simulation.setGraph(graph);
        return simulation;
    }

    public static Simulation createSimulationFromSBML() {
        logger.debug("Adjusting time step size ... ");
        EnvironmentalParameters.setTimeStep((Quantity)Quantities.getQuantity((Number)1.0, (Unit)Units.SECOND));
        Simulation simulation = new Simulation();
        logger.info("Setting up simulation for model BIOMD0000000184 ...");
        SBMLParser model = BioModelsParserService.parseModelById("BIOMD0000000184");
        logger.debug("Setting up example graph ...");
        AutomatonGraph graph = AutomatonGraphs.singularGraph();
        model.getCompartments().keySet().forEach(graph::addCellSection);
        logger.debug("Initializing starting concentrations of species and node states in graph ...");
        AutomatonNode bioNode = (AutomatonNode)((Object)graph.getNodes().iterator().next());
        model.getStartingConcentrations().forEach((entity, value) -> {
            logger.debug("Initialized concentration of {} to {}.", (Object)entity.getIdentifier(), value);
            bioNode.setConcentration((ChemicalEntity)entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)value, (Unit)UnitProvider.MOLE_PER_LITRE).to(EnvironmentalParameters.getTransformedMolarConcentration()));
        });
        simulation.setGraph(graph);
        model.getReactions().forEach(reaction -> reaction.setSimulation(simulation));
        simulation.getModules().addAll(model.getReactions());
        simulation.setAssignmentRules(new ArrayList<AssignmentRule>(model.getAssignmentRules()));
        simulation.applyAssignmentRules();
        return simulation;
    }

    public static Simulation createCompartmentTestEnvironment() {
        logger.info("Setting up Compartment Test Example ...");
        logger.debug("Setting up example graph ...");
        int numberOfNodes = 50;
        AutomatonGraph graph = AutomatonGraphs.useStructureFrom(Graphs.buildGridGraph((int)numberOfNodes, (int)numberOfNodes));
        logger.debug("Composing simulation ... ");
        Simulation simulation = new Simulation();
        simulation.setGraph(graph);
        return simulation;
    }

    public static Simulation createPassiveMembraneTransportExample() {
        logger.info("Setting up the passive membrane diffusion example ...");
        logger.debug("Importing species ...");
        logger.debug("Adjusting time step size ... ");
        EnvironmentalParameters.setTimeStep((Quantity)Quantities.getQuantity((Number)100, (Unit)MetricPrefix.NANO((Unit)Units.SECOND)));
        logger.debug("Adjusting spatial step size ... ");
        EnvironmentalParameters.setNodeSpacingToDiameter((Quantity)Quantities.getQuantity((Number)2500.0, (Unit)MetricPrefix.NANO((Unit)Units.METRE)), (int)11);
        HashSet<Species> allSpecies = new HashSet<Species>();
        Species domperidone = PubChemParserService.parse((String)"CID:3151");
        domperidone.setFeature((Feature)new MembraneEntry(1.48E9, FeatureOrigin.MANUALLY_ANNOTATED));
        domperidone.setFeature((Feature)new MembraneExit(1760.0, FeatureOrigin.MANUALLY_ANNOTATED));
        domperidone.setFeature((Feature)new MembraneFlipFlop(350.0, FeatureOrigin.MANUALLY_ANNOTATED));
        allSpecies.add(domperidone);
        Species loperamide = PubChemParserService.parse((String)"CID:3955");
        loperamide.setFeature((Feature)new MembraneEntry(8.59E8, FeatureOrigin.MANUALLY_ANNOTATED));
        loperamide.setFeature((Feature)new MembraneExit(1810.0, FeatureOrigin.MANUALLY_ANNOTATED));
        loperamide.setFeature((Feature)new MembraneFlipFlop(671000.0, FeatureOrigin.MANUALLY_ANNOTATED));
        allSpecies.add(loperamide);
        Species propranolol = PubChemParserService.parse((String)"CID:4946");
        propranolol.setFeature((Feature)new MembraneEntry(1.27E9, FeatureOrigin.MANUALLY_ANNOTATED));
        propranolol.setFeature((Feature)new MembraneExit(30900.0, FeatureOrigin.MANUALLY_ANNOTATED));
        propranolol.setFeature((Feature)new MembraneFlipFlop(4750000.0, FeatureOrigin.MANUALLY_ANNOTATED));
        allSpecies.add(propranolol);
        Species desipramine = PubChemParserService.parse((String)"CID:2995");
        desipramine.setFeature((Feature)new MembraneEntry(2.13E9, FeatureOrigin.MANUALLY_ANNOTATED));
        desipramine.setFeature((Feature)new MembraneExit(48600.0, FeatureOrigin.MANUALLY_ANNOTATED));
        desipramine.setFeature((Feature)new MembraneFlipFlop(1.09E7, FeatureOrigin.MANUALLY_ANNOTATED));
        allSpecies.add(desipramine);
        EnclosedCompartment left = new EnclosedCompartment("LC", "Left");
        EnclosedCompartment right = new EnclosedCompartment("RC", "Right");
        logger.debug("Setting up example graph ...");
        AutomatonGraph graph = AutomatonGraphs.createRectangularAutomatonGraph(11, 11);
        AutomatonGraphs.splitRectangularGraphWithMembrane(graph, right, left);
        for (AutomatonNode node : graph.getNodes()) {
            if (((RectangularCoordinate)node.getIdentifier()).getColumn() < graph.getNumberOfColumns() / 2) {
                for (Species species : allSpecies) {
                    node.setConcentration((ChemicalEntity)species, 1.0);
                }
                continue;
            }
            for (Species species : allSpecies) {
                node.setConcentration((ChemicalEntity)species, 0.0);
            }
        }
        logger.debug("Composing simulation ... ");
        Simulation simulation = new Simulation();
        simulation.setGraph(graph);
        simulation.getModules().add(new FlipFlopMembraneTransport(simulation));
        simulation.getChemicalEntities().addAll(allSpecies);
        simulation.getModules().add(new FreeDiffusion(simulation, simulation.getChemicalEntities()));
        return simulation;
    }

    public static Simulation createDiffusionAndMembraneTransportExample() {
        Species domperidone = (Species)((Species.Builder)((Species.Builder)((Species.Builder)((Species.Builder)((Species.Builder)new Species.Builder("CHEBI:31515").name("domperidone")).assignFeature(Diffusivity.class)).assignFeature((Feature)new MembraneEntry(1.48E9, FeatureOrigin.MANUALLY_ANNOTATED))).assignFeature((Feature)new MembraneExit(1760.0, FeatureOrigin.MANUALLY_ANNOTATED))).assignFeature((Feature)new MembraneFlipFlop(350.0, FeatureOrigin.MANUALLY_ANNOTATED))).build();
        Simulation simulation = new Simulation();
        GridCoordinateConverter gcc = new GridCoordinateConverter(30, 20);
        AutomatonGraph graph = AutomatonGraphs.useStructureFrom(Graphs.buildGridGraph((int)20, (int)30));
        EnclosedCompartment inner = new EnclosedCompartment("I", "Inner");
        EnclosedCompartment outer = new EnclosedCompartment("O", "Outer");
        Membrane membrane = Membrane.forCompartment(inner);
        for (AutomatonNode node : graph.getNodes()) {
            RectangularCoordinate coordinate = (RectangularCoordinate)node.getIdentifier();
            if (coordinate.getColumn() == 2 && coordinate.getRow() > 2 && coordinate.getRow() < 17 || coordinate.getColumn() == 27 && coordinate.getRow() > 2 && coordinate.getRow() < 17 || coordinate.getRow() == 2 && coordinate.getColumn() > 1 && coordinate.getColumn() < 28 || coordinate.getRow() == 17 && coordinate.getColumn() > 1 && coordinate.getColumn() < 28) {
                node.setCellSection(membrane);
                node.setConcentrationContainer(new MembraneContainer(outer, inner, membrane));
                node.setAvailableConcentration((ChemicalEntity)domperidone, outer, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)1.0, (Unit)UnitProvider.MOLE_PER_LITRE).to(EnvironmentalParameters.getTransformedMolarConcentration()));
                continue;
            }
            if (coordinate.getColumn() > 2 && coordinate.getRow() > 2 && coordinate.getColumn() < 27 && coordinate.getRow() < 17) {
                node.setCellSection(inner);
                node.setConcentration((ChemicalEntity)domperidone, 0.0);
                continue;
            }
            node.setCellSection(outer);
            node.setConcentration((ChemicalEntity)domperidone, 1.0);
        }
        simulation.setGraph(graph);
        FreeDiffusion diffusion = new FreeDiffusion(simulation, simulation.getChemicalEntities());
        FlipFlopMembraneTransport membraneTransport = new FlipFlopMembraneTransport(simulation);
        simulation.getModules().add(diffusion);
        simulation.getModules().add(membraneTransport);
        return simulation;
    }
}

