/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.simulation.events.EpochUpdateWriter;
import de.bioforscher.singa.simulation.model.graphs.AutomatonGraph;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.model.parameters.SimulationParameter;
import de.bioforscher.singa.simulation.model.rules.AssignmentRule;
import de.bioforscher.singa.simulation.model.rules.AssignmentRules;
import de.bioforscher.singa.simulation.modules.model.Module;
import de.bioforscher.singa.simulation.modules.model.TimeStepHarmonizer;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;

public class Simulation {
    private static final Logger logger = LoggerFactory.getLogger(Simulation.class);
    private final Set<Module> modules = new HashSet<Module>();
    private final TimeStepHarmonizer harmonizer;
    private AutomatonGraph graph;
    private EpochUpdateWriter epochUpdateWriter;
    private Set<AutomatonNode> observedNodes;
    private List<AssignmentRule> assignmentRules;
    private Set<ChemicalEntity> chemicalEntities = new HashSet<ChemicalEntity>();
    private Set<SimulationParameter> globalParameters;
    private long epoch = 0L;
    private ComparableQuantity<Time> elapsedTime;

    public Simulation() {
        this.observedNodes = new HashSet<AutomatonNode>();
        this.elapsedTime = Quantities.getQuantity((Number)0.0, (Unit)EnvironmentalParameters.getTimeStep().getUnit());
        this.harmonizer = new TimeStepHarmonizer(this);
    }

    public void nextEpoch() {
        logger.debug("Starting epoch {} ({}).", (Object)this.epoch, this.elapsedTime);
        if (!this.observedNodes.isEmpty()) {
            for (AutomatonNode observedNode : this.observedNodes) {
                observedNode.clearPotentialDeltas();
            }
        }
        boolean timeStepChanged = this.harmonizer.step();
        logger.debug("Applying deltas.");
        for (AutomatonNode node : this.getGraph().getNodes()) {
            node.applyDeltas();
        }
        this.updateEpoch();
        if (!timeStepChanged && this.harmonizer.getEpsilon() - this.harmonizer.getLargestLocalError().getValue() > 0.1 * this.harmonizer.getEpsilon()) {
            this.harmonizer.increaseTimeStep();
        }
    }

    private void updateEpoch() {
        ++this.epoch;
        this.elapsedTime = this.elapsedTime.add(EnvironmentalParameters.getTimeStep());
    }

    public void applyAssignmentRules() {
        for (AssignmentRule rule : this.assignmentRules) {
            for (AutomatonNode bioNode : this.graph.getNodes()) {
                rule.applyRule(bioNode);
            }
        }
    }

    public AutomatonGraph getGraph() {
        return this.graph;
    }

    public void setGraph(AutomatonGraph graph) {
        this.graph = graph;
    }

    public Set<Module> getModules() {
        return this.modules;
    }

    public List<AssignmentRule> getAssignmentRules() {
        return this.assignmentRules;
    }

    public void setAssignmentRules(List<AssignmentRule> assignmentRules) {
        this.assignmentRules = AssignmentRules.sortAssignmentRulesByPriority(assignmentRules);
    }

    public Set<ChemicalEntity> getChemicalEntities() {
        return this.chemicalEntities;
    }

    public void setChemicalEntities(Set<ChemicalEntity> chemicalEntities) {
        this.chemicalEntities = chemicalEntities;
    }

    public void setEpochUpdateWriter(EpochUpdateWriter epochUpdateWriter) {
        this.epochUpdateWriter = epochUpdateWriter;
    }

    public void observeNode(AutomatonNode node) {
        this.observedNodes.add(node);
        node.setObserved(true);
        if (this.epochUpdateWriter != null) {
            try {
                this.epochUpdateWriter.addNodeToObserve(node);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Set<AutomatonNode> getObservedNodes() {
        return this.observedNodes;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public ComparableQuantity<Time> getElapsedTime() {
        return this.elapsedTime;
    }

    public void setEpsilon(double epsilon) {
        this.harmonizer.setEpsilon(epsilon);
    }
}

