/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.modules.model.Module;
import javax.measure.Quantity;

public class Delta {
    private final Module module;
    private final CellSection cellSection;
    private final ChemicalEntity chemicalEntity;
    private Quantity<MolarConcentration> quantity;

    public Delta(Module module, CellSection cellSection, ChemicalEntity chemicalEntity, Quantity<MolarConcentration> quantity) {
        this.module = module;
        this.chemicalEntity = chemicalEntity;
        this.cellSection = cellSection;
        this.quantity = quantity;
    }

    public Module getModule() {
        return this.module;
    }

    public CellSection getCellSection() {
        return this.cellSection;
    }

    public ChemicalEntity getChemicalEntity() {
        return this.chemicalEntity;
    }

    public Quantity<MolarConcentration> getQuantity() {
        return this.quantity;
    }

    public Delta multiply(double multiplicand) {
        this.quantity = this.quantity.multiply((Number)multiplicand);
        return this;
    }

    public String toString() {
        return this.module + " : " + this.cellSection.getIdentifier() + "-" + this.chemicalEntity.getIdentifier() + " = " + EnvironmentalParameters.DELTA_FORMATTER.format(this.quantity);
    }
}

