/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.model.graphs.AutomatonGraph;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.modules.model.AbstractModule;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.DeltaIdentifier;
import de.bioforscher.singa.simulation.modules.model.LocalError;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.quantity.Quantities;

public abstract class AbstractSectionSpecificModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSectionSpecificModule.class);
    private final Map<Function<ConcentrationContainer, List<Delta>>, Predicate<ConcentrationContainer>> deltaFunctions = new HashMap<Function<ConcentrationContainer, List<Delta>>, Predicate<ConcentrationContainer>>();
    private ConcentrationContainer currentHalfConcentrations;

    public AbstractSectionSpecificModule(Simulation simulation) {
        super(simulation);
    }

    public void addDeltaFunction(Function<ConcentrationContainer, List<Delta>> deltaFunction, Predicate<ConcentrationContainer> predicate) {
        this.deltaFunctions.put(deltaFunction, predicate);
    }

    @Override
    public void determineAllDeltas() {
        AutomatonGraph graph = this.simulation.getGraph();
        for (AutomatonNode node : graph.getNodes()) {
            if (!this.conditionalApplication.test(node)) continue;
            this.determineDeltasForNode(node);
        }
    }

    @Override
    public LocalError determineDeltasForNode(AutomatonNode node) {
        this.currentNode = node;
        ConcentrationContainer fullConcentrations = node.getConcentrationContainer();
        this.currentHalfConcentrations = fullConcentrations.getCopy();
        return this.determineDeltas(fullConcentrations);
    }

    public LocalError determineDeltas(ConcentrationContainer concentrationContainer) {
        CellSection cellSection;
        this.halfTime = false;
        Iterator<CellSection> iterator = this.currentNode.getAllReferencedSections().iterator();
        while (iterator.hasNext()) {
            this.currentCellSection = cellSection = iterator.next();
            this.determineFullDeltas(concentrationContainer);
        }
        this.halfTime = true;
        iterator = this.currentNode.getAllReferencedSections().iterator();
        while (iterator.hasNext()) {
            this.currentCellSection = cellSection = iterator.next();
            this.determineHalfDeltas(concentrationContainer);
        }
        this.largestLocalError = this.determineLargestLocalError();
        this.currentFullDeltas.clear();
        this.currentHalfDeltas.clear();
        return this.largestLocalError;
    }

    private void determineFullDeltas(ConcentrationContainer concentrationContainer) {
        for (Map.Entry<Function<ConcentrationContainer, List<Delta>>, Predicate<ConcentrationContainer>> entry : this.deltaFunctions.entrySet()) {
            if (!entry.getValue().test(concentrationContainer)) continue;
            List<Delta> fullDeltas = entry.getKey().apply(concentrationContainer);
            ArrayList<ChemicalEntity> unchangedEntities = new ArrayList<ChemicalEntity>(concentrationContainer.getAllReferencedEntities());
            for (Delta fullDelta : fullDeltas) {
                this.currentChemicalEntity = fullDelta.getChemicalEntity();
                if (!this.deltaIsValid(fullDelta)) continue;
                this.setHalfStepConcentration(fullDelta);
                this.currentFullDeltas.put(new DeltaIdentifier(this.currentNode, this.currentCellSection, this.currentChemicalEntity), fullDelta);
                unchangedEntities.remove(fullDelta.getChemicalEntity());
            }
            for (ChemicalEntity unchangedEntity : unchangedEntities) {
                this.currentHalfConcentrations.setAvailableConcentration(this.currentCellSection, unchangedEntity, this.currentNode.getAvailableConcentration(unchangedEntity, this.currentCellSection));
            }
        }
    }

    private void setHalfStepConcentration(Delta fullDelta) {
        double fullConcentration = this.currentNode.getAvailableConcentration(fullDelta.getChemicalEntity(), fullDelta.getCellSection()).getValue().doubleValue();
        double halfStepConcentration = fullConcentration + 0.5 * fullDelta.getQuantity().getValue().doubleValue();
        this.currentHalfConcentrations.setAvailableConcentration(fullDelta.getCellSection(), fullDelta.getChemicalEntity(), (Quantity<MolarConcentration>)Quantities.getQuantity((Number)halfStepConcentration, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    private void determineHalfDeltas(ConcentrationContainer concentrationContainer) {
        for (Map.Entry<Function<ConcentrationContainer, List<Delta>>, Predicate<ConcentrationContainer>> entry : this.deltaFunctions.entrySet()) {
            if (!entry.getValue().test(concentrationContainer)) continue;
            List<Delta> halfDeltas = entry.getKey().apply(this.currentHalfConcentrations);
            for (Delta halfDelta : halfDeltas) {
                this.currentChemicalEntity = halfDelta.getChemicalEntity();
                this.applyHalfDelta(halfDelta);
            }
        }
    }
}

