/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.model.graphs.AutomatonGraph;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.modules.model.AbstractModule;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.DeltaIdentifier;
import de.bioforscher.singa.simulation.modules.model.LocalError;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tec.uom.se.quantity.Quantities;

public abstract class AbstractNeighbourIndependentModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNeighbourIndependentModule.class);
    private final Map<Function<ConcentrationContainer, Delta>, Predicate<ConcentrationContainer>> deltaFunctions = new HashMap<Function<ConcentrationContainer, Delta>, Predicate<ConcentrationContainer>>();
    private ConcentrationContainer currentHalfConcentrations;

    public AbstractNeighbourIndependentModule(Simulation simulation) {
        super(simulation);
    }

    public void addDeltaFunction(Function<ConcentrationContainer, Delta> deltaFunction, Predicate<ConcentrationContainer> predicate) {
        this.deltaFunctions.put(deltaFunction, predicate);
    }

    @Override
    public void determineAllDeltas() {
        AutomatonGraph graph = this.simulation.getGraph();
        for (AutomatonNode node : graph.getNodes()) {
            if (!this.conditionalApplication.test(node)) continue;
            logger.trace("Determining delta for node {}.", node.getIdentifier());
            this.determineDeltasForNode(node);
        }
    }

    @Override
    public LocalError determineDeltasForNode(AutomatonNode node) {
        this.currentNode = node;
        ConcentrationContainer fullConcentrations = node.getConcentrationContainer();
        this.currentHalfConcentrations = fullConcentrations.getCopy();
        return this.determineDeltas(fullConcentrations);
    }

    public LocalError determineDeltas(ConcentrationContainer concentrationContainer) {
        ChemicalEntity chemicalEntity;
        Iterator<ChemicalEntity> iterator;
        CellSection cellSection;
        this.halfTime = false;
        Iterator<CellSection> iterator2 = this.currentNode.getAllReferencedSections().iterator();
        while (iterator2.hasNext()) {
            this.currentCellSection = cellSection = iterator2.next();
            iterator = this.currentNode.getAllReferencedEntities().iterator();
            while (iterator.hasNext()) {
                this.currentChemicalEntity = chemicalEntity = iterator.next();
                this.determineFullDeltas(concentrationContainer);
            }
        }
        this.halfTime = true;
        iterator2 = this.currentNode.getAllReferencedSections().iterator();
        while (iterator2.hasNext()) {
            this.currentCellSection = cellSection = iterator2.next();
            iterator = this.currentNode.getAllReferencedEntities().iterator();
            while (iterator.hasNext()) {
                this.currentChemicalEntity = chemicalEntity = iterator.next();
                this.determineHalfDeltas(concentrationContainer);
            }
        }
        this.largestLocalError = this.determineLargestLocalError();
        this.currentFullDeltas.clear();
        this.currentHalfDeltas.clear();
        return this.largestLocalError;
    }

    private void determineFullDeltas(ConcentrationContainer concentrationContainer) {
        for (Map.Entry<Function<ConcentrationContainer, Delta>, Predicate<ConcentrationContainer>> entry : this.deltaFunctions.entrySet()) {
            Delta fullDelta;
            if (!entry.getValue().test(concentrationContainer) || !this.deltaIsValid(fullDelta = entry.getKey().apply(concentrationContainer))) continue;
            this.setHalfStepConcentration(fullDelta);
            logger.trace("Calculated full delta for {} in {}: {}", new Object[]{this.getCurrentChemicalEntity().getName(), this.getCurrentCellSection().getIdentifier(), fullDelta.getQuantity()});
            this.currentFullDeltas.put(new DeltaIdentifier(this.currentNode, this.currentCellSection, this.currentChemicalEntity), fullDelta);
        }
    }

    private void setHalfStepConcentration(Delta fullDelta) {
        double fullConcentration = this.currentNode.getAvailableConcentration(this.currentChemicalEntity, this.currentCellSection).getValue().doubleValue();
        double halfStepConcentration = fullConcentration + 0.5 * fullDelta.getQuantity().getValue().doubleValue();
        this.currentHalfConcentrations.setAvailableConcentration(this.currentCellSection, this.currentChemicalEntity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)halfStepConcentration, (Unit)EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    private void determineHalfDeltas(ConcentrationContainer concentrationContainer) {
        for (Map.Entry<Function<ConcentrationContainer, Delta>, Predicate<ConcentrationContainer>> entry : this.deltaFunctions.entrySet()) {
            if (!entry.getValue().test(concentrationContainer)) continue;
            Delta halfDelta = entry.getKey().apply(this.currentHalfConcentrations);
            this.applyHalfDelta(halfDelta);
        }
    }
}

