/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.model.graphs.AutomatonGraph;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.modules.model.AbstractModule;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.DeltaIdentifier;
import de.bioforscher.singa.simulation.modules.model.LocalError;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.measure.Quantity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNeighbourDependentModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(AbstractNeighbourDependentModule.class);
    private final Map<AutomatonNode, ConcentrationContainer> halfConcentrations;
    private final Map<Function<ConcentrationContainer, Delta>, Predicate<ConcentrationContainer>> deltaFunctions = new HashMap<Function<ConcentrationContainer, Delta>, Predicate<ConcentrationContainer>>();

    public AbstractNeighbourDependentModule(Simulation simulation) {
        super(simulation);
        this.halfConcentrations = new HashMap<AutomatonNode, ConcentrationContainer>();
    }

    public void addDeltaFunction(Function<ConcentrationContainer, Delta> deltaFunction, Predicate<ConcentrationContainer> predicate) {
        this.deltaFunctions.put(deltaFunction, predicate);
    }

    @Override
    public void determineAllDeltas() {
        AutomatonGraph graph = this.simulation.getGraph();
        this.halfTime = false;
        for (AutomatonNode automatonNode : graph.getNodes()) {
            if (!this.conditionalApplication.test(automatonNode)) continue;
            this.currentNode = automatonNode;
            this.determineFullDeltas(automatonNode.getConcentrationContainer());
        }
        this.determineHalfStepConcentration();
        this.halfTime = true;
        for (Map.Entry entry : this.halfConcentrations.entrySet()) {
            this.currentNode = (AutomatonNode)((Object)entry.getKey());
            this.determineHalfStepDeltas((ConcentrationContainer)entry.getValue());
        }
        this.largestLocalError = this.determineLargestLocalError();
        this.currentFullDeltas.clear();
        this.currentHalfDeltas.clear();
    }

    @Override
    public LocalError determineDeltasForNode(AutomatonNode node) {
        this.determineAllDeltas();
        return this.largestLocalError;
    }

    public void determineFullDeltas(ConcentrationContainer concentrationContainer) {
        logger.trace("Determining full deltas for node {}.", this.currentNode.getIdentifier());
        Iterator<CellSection> iterator = this.currentNode.getAllReferencedSections().iterator();
        while (iterator.hasNext()) {
            CellSection cellSection;
            this.currentCellSection = cellSection = iterator.next();
            Iterator<ChemicalEntity> iterator2 = this.currentNode.getAllReferencedEntities().iterator();
            while (iterator2.hasNext()) {
                ChemicalEntity chemicalEntity;
                this.currentChemicalEntity = chemicalEntity = iterator2.next();
                for (Map.Entry<Function<ConcentrationContainer, Delta>, Predicate<ConcentrationContainer>> entry : this.deltaFunctions.entrySet()) {
                    Delta fullDelta;
                    if (!entry.getValue().test(concentrationContainer) || !this.deltaIsValid(fullDelta = entry.getKey().apply(concentrationContainer))) continue;
                    logger.trace("Calculated full delta for {} in {}: {}", new Object[]{this.getCurrentChemicalEntity().getName(), this.getCurrentCellSection().getIdentifier(), fullDelta.getQuantity()});
                    this.currentFullDeltas.put(new DeltaIdentifier(this.currentNode, this.currentCellSection, this.currentChemicalEntity), fullDelta);
                }
            }
        }
    }

    private void determineHalfStepDeltas(ConcentrationContainer concentrationContainer) {
        logger.trace("Determining half deltas for node {}.", this.currentNode.getIdentifier());
        Iterator<CellSection> iterator = this.currentNode.getAllReferencedSections().iterator();
        while (iterator.hasNext()) {
            CellSection cellSection;
            this.currentCellSection = cellSection = iterator.next();
            Iterator<ChemicalEntity> iterator2 = this.currentNode.getAllReferencedEntities().iterator();
            while (iterator2.hasNext()) {
                ChemicalEntity chemicalEntity;
                this.currentChemicalEntity = chemicalEntity = iterator2.next();
                for (Map.Entry<Function<ConcentrationContainer, Delta>, Predicate<ConcentrationContainer>> entry : this.deltaFunctions.entrySet()) {
                    if (!entry.getValue().test(concentrationContainer)) continue;
                    Delta halfDelta = entry.getKey().apply(concentrationContainer);
                    this.applyHalfDelta(halfDelta);
                }
            }
        }
    }

    @Override
    void applyHalfDelta(Delta halfDelta) {
        halfDelta = halfDelta.multiply(2.0);
        logger.trace("Calculated half delta for {} in {}: {}", new Object[]{this.currentChemicalEntity.getName(), this.currentCellSection.getIdentifier(), halfDelta.getQuantity()});
        this.currentHalfDeltas.put(new DeltaIdentifier(this.currentNode, this.currentCellSection, this.currentChemicalEntity), halfDelta);
        this.currentNode.addPotentialDelta(halfDelta);
    }

    private void determineHalfStepConcentration() {
        for (Map.Entry entry : this.currentFullDeltas.entrySet()) {
            ConcentrationContainer halfConcentration;
            DeltaIdentifier key = (DeltaIdentifier)entry.getKey();
            Delta value = (Delta)entry.getValue();
            Quantity<MolarConcentration> fullConcentration = key.getNode().getAvailableConcentration(key.getEntity(), key.getSection());
            Quantity halfStepConcentration = fullConcentration.add(value.getQuantity().multiply((Number)0.5));
            if (!this.halfConcentrations.containsKey((Object)key.getNode())) {
                halfConcentration = key.getNode().getConcentrationContainer().getCopy();
                halfConcentration.setAvailableConcentration(key.getSection(), key.getEntity(), (Quantity<MolarConcentration>)halfStepConcentration);
                this.halfConcentrations.put(key.getNode(), halfConcentration);
                continue;
            }
            halfConcentration = this.halfConcentrations.get((Object)key.getNode());
            halfConcentration.setAvailableConcentration(key.getSection(), key.getEntity(), (Quantity<MolarConcentration>)halfStepConcentration);
        }
    }
}

