/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.modules.model;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.model.Featureable;
import de.bioforscher.singa.features.model.ScalableFeature;
import de.bioforscher.singa.simulation.exceptions.NumericalInstabilityException;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.DeltaIdentifier;
import de.bioforscher.singa.simulation.modules.model.LocalError;
import de.bioforscher.singa.simulation.modules.model.Module;
import de.bioforscher.singa.simulation.modules.model.Simulation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModule
implements Module {
    public static final double DEFAULT_NUMERICAL_CUTOFF = 1.0E-100;
    private static final Logger logger = LoggerFactory.getLogger(AbstractModule.class);
    protected final Map<DeltaIdentifier, Delta> currentFullDeltas;
    protected final Map<DeltaIdentifier, Delta> currentHalfDeltas;
    protected Simulation simulation;
    protected Predicate<AutomatonNode> conditionalApplication = automatonNode -> true;
    protected LocalError largestLocalError = LocalError.MINIMAL_EMPTY_ERROR;
    protected boolean halfTime;
    protected AutomatonNode currentNode;
    protected CellSection currentCellSection;
    protected ChemicalEntity currentChemicalEntity;
    private double numericalCutoff = 1.0E-100;

    public AbstractModule(Simulation simulation) {
        this.simulation = simulation;
        this.currentFullDeltas = new HashMap<DeltaIdentifier, Delta>();
        this.currentHalfDeltas = new HashMap<DeltaIdentifier, Delta>();
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(Simulation simulation) {
        this.simulation = simulation;
    }

    public AutomatonNode getCurrentNode() {
        return this.currentNode;
    }

    public CellSection getCurrentCellSection() {
        return this.currentCellSection;
    }

    public ChemicalEntity getCurrentChemicalEntity() {
        return this.currentChemicalEntity;
    }

    public void onlyApplyIf(Predicate<AutomatonNode> predicate) {
        this.conditionalApplication = predicate;
    }

    public double getNumericalCutoff() {
        return this.numericalCutoff;
    }

    public void setNumericalCutoff(double numericalCutoff) {
        this.numericalCutoff = numericalCutoff;
    }

    protected <FeatureContent> FeatureContent getFeature(Featureable entity, Class<? extends ScalableFeature<FeatureContent>> featureClass) {
        ScalableFeature feature = (ScalableFeature)entity.getFeature(featureClass);
        if (this.halfTime) {
            return (FeatureContent)feature.getHalfScaledQuantity();
        }
        return (FeatureContent)feature.getScaledQuantity();
    }

    @Override
    public LocalError getLargestLocalError() {
        return this.largestLocalError;
    }

    @Override
    public void resetLargestLocalError() {
        this.largestLocalError = LocalError.MINIMAL_EMPTY_ERROR;
    }

    void applyHalfDelta(Delta halfDelta) {
        if (this.deltaIsValid(halfDelta)) {
            halfDelta = halfDelta.multiply(2.0);
            logger.trace("Calculated half delta for {} in {}: {}", new Object[]{this.currentChemicalEntity.getName(), this.currentCellSection.getIdentifier(), halfDelta.getQuantity()});
            this.currentHalfDeltas.put(new DeltaIdentifier(this.currentNode, this.currentCellSection, this.currentChemicalEntity), halfDelta);
            this.currentNode.addPotentialDelta(halfDelta);
        }
    }

    boolean deltaIsValid(Delta delta) {
        return this.deltaIsNotZero(delta) && this.deltaIsAboveNumericCutoff(delta);
    }

    private boolean deltaIsNotZero(Delta delta) {
        return delta.getQuantity().getValue().doubleValue() != 0.0;
    }

    private boolean deltaIsAboveNumericCutoff(Delta delta) {
        return Math.abs(delta.getQuantity().getValue().doubleValue()) > this.numericalCutoff;
    }

    LocalError determineLargestLocalError() {
        if (this.currentFullDeltas.isEmpty()) {
            return LocalError.MINIMAL_EMPTY_ERROR;
        }
        double largestLocalError = -1.7976931348623157E308;
        DeltaIdentifier largestIdentifier = null;
        for (DeltaIdentifier identifier : this.currentFullDeltas.keySet()) {
            double fullDelta = this.currentFullDeltas.get(identifier).getQuantity().getValue().doubleValue();
            double halfDelta = this.currentHalfDeltas.get(identifier).getQuantity().getValue().doubleValue();
            if (halfDelta == 0.0) continue;
            double localError = Math.abs(1.0 - fullDelta / halfDelta);
            if (localError > 100.0) {
                throw new NumericalInstabilityException("The simulation experiences numerical instabilities. The local error between the full step delta (" + fullDelta + ") and half step delta (" + halfDelta + ") is " + localError + ". This can be an result of time steps that have been initially chosen too large or an implementation error in module that calculated the delta.");
            }
            if (!(largestLocalError < localError)) continue;
            largestIdentifier = identifier;
            largestLocalError = localError;
        }
        if (largestIdentifier == null) {
            return LocalError.MINIMAL_EMPTY_ERROR;
        }
        return new LocalError(largestIdentifier.getNode(), largestIdentifier.getEntity(), largestLocalError);
    }
}

