/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.rules;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.model.parameters.SimulationParameter;
import de.bioforscher.singa.simulation.model.rules.AppliedExpression;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Quantity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentRule {
    private static final Logger logger = LoggerFactory.getLogger(AssignmentRule.class);
    private final AppliedExpression expression;
    private ChemicalEntity targetEntity;
    private Map<ChemicalEntity, String> entityReference;

    public AssignmentRule(ChemicalEntity targetEntity, AppliedExpression expression) {
        this.targetEntity = targetEntity;
        this.expression = expression;
        this.entityReference = new HashMap<ChemicalEntity, String>();
    }

    public ChemicalEntity getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(ChemicalEntity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void referenceChemicalEntityToParameter(String parameterIdentifier, ChemicalEntity entity) {
        this.entityReference.put(entity, parameterIdentifier);
        this.expression.setParameter(new SimulationParameter(parameterIdentifier, EnvironmentalParameters.emptyConcentration()));
    }

    public Map<ChemicalEntity, String> getEntityReference() {
        return this.entityReference;
    }

    public void setEntityReference(Map<ChemicalEntity, String> entityReference) {
        this.entityReference = entityReference;
    }

    public void applyRule(AutomatonNode node) {
        for (Map.Entry<ChemicalEntity, String> entry : this.entityReference.entrySet()) {
            Quantity<MolarConcentration> concentration = node.getConcentration(entry.getKey());
            String parameterName = this.entityReference.get(entry.getKey());
            this.expression.acceptValue(parameterName, concentration.getValue().doubleValue());
        }
        Quantity<?> concentration = this.expression.evaluate();
        logger.debug("Initialized concentration of {} to {}.", (Object)this.targetEntity.getIdentifier(), concentration);
        node.setConcentration(this.targetEntity, concentration.getValue().doubleValue());
    }
}

