/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.parameters;

import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.Diffusivity;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import tec.uom.se.AbstractUnit;
import tec.uom.se.unit.ProductUnit;

public class UnitScaler {
    public static Quantity<Frequency> rescaleReactionRate(Quantity<Frequency> unscaledQuantity, Quantity<Time> targetScale) {
        Quantity scaledQuantity = unscaledQuantity.to((Unit)new ProductUnit(AbstractUnit.ONE.divide(targetScale.getUnit())));
        scaledQuantity = scaledQuantity.multiply(targetScale.getValue());
        return scaledQuantity;
    }

    public static Quantity<Diffusivity> rescaleDiffusivity(Quantity<Diffusivity> unscaledQuantity, Quantity<Time> targetTimeScale, Quantity<Length> targetLengthScale) {
        Quantity scaledQuantity = unscaledQuantity.to((Unit)new ProductUnit(targetLengthScale.getUnit().pow(2).divide(targetTimeScale.getUnit())));
        scaledQuantity = scaledQuantity.divide(targetLengthScale.getValue()).divide(targetLengthScale.getValue()).multiply(targetTimeScale.getValue());
        return scaledQuantity;
    }
}

