/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.parameters;

import de.bioforscher.singa.chemistry.descriptive.annotations.Annotatable;
import de.bioforscher.singa.chemistry.descriptive.annotations.Annotation;
import de.bioforscher.singa.core.utility.Nameable;
import de.bioforscher.singa.features.identifiers.SimpleStringIdentifier;
import de.bioforscher.singa.features.identifiers.model.Identifiable;
import java.util.ArrayList;
import java.util.List;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.quantity.Quantities;

public class SimulationParameter<QuantityType extends Quantity<QuantityType>>
implements Identifiable<SimpleStringIdentifier>,
Nameable,
Annotatable {
    private final SimpleStringIdentifier identifier;
    private final List<Annotation> annotations;
    private String name;
    private Quantity<QuantityType> quantity;

    public SimulationParameter(String identifier) {
        this.identifier = new SimpleStringIdentifier(identifier);
        this.annotations = new ArrayList<Annotation>();
    }

    public SimulationParameter(String identifier, Quantity<QuantityType> quantity) {
        this(identifier);
        this.quantity = quantity;
    }

    public SimpleStringIdentifier getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Quantity<QuantityType> getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Quantity<QuantityType> quantity) {
        this.quantity = quantity;
    }

    public double getValue() {
        return this.quantity.getValue().doubleValue();
    }

    public void setValue(double value) {
        this.quantity = Quantities.getQuantity((Number)value, (Unit)this.quantity.getUnit());
    }
}

