/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.graphs;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.features.units.UnitProvider;
import de.bioforscher.singa.mathematics.graphs.model.AbstractNode;
import de.bioforscher.singa.mathematics.topology.grids.rectangular.RectangularCoordinate;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.compartments.EnclosedCompartment;
import de.bioforscher.singa.simulation.model.compartments.Membrane;
import de.bioforscher.singa.simulation.model.compartments.NodeState;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import de.bioforscher.singa.simulation.model.concentrations.SimpleConcentrationContainer;
import de.bioforscher.singa.simulation.modules.model.Delta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.quantity.Quantities;

public class AutomatonNode
extends AbstractNode<AutomatonNode, Vector2D, RectangularCoordinate> {
    private final List<Delta> finalDeltas;
    private final List<Delta> potentialDeltas;
    private NodeState state = NodeState.AQUEOUS;
    private CellSection cellSection = new EnclosedCompartment("default", "Default Compartment");
    private ConcentrationContainer concentrationContainer = new SimpleConcentrationContainer(this.cellSection);
    private boolean observed = false;
    private boolean concentrationFixed = false;

    public AutomatonNode(RectangularCoordinate identifier) {
        super((Object)identifier);
        this.finalDeltas = new ArrayList<Delta>();
        this.potentialDeltas = new ArrayList<Delta>();
    }

    public AutomatonNode(int column, int row) {
        this(new RectangularCoordinate(column, row));
    }

    public void setConcentrations(double concentration, ChemicalEntity ... entities) {
        for (ChemicalEntity entity : entities) {
            this.setConcentration(entity, concentration);
        }
    }

    public void setConcentration(ChemicalEntity entity, double concentration) {
        this.setConcentration(entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)concentration, (Unit)UnitProvider.MOLE_PER_LITRE).to(EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    public void setConcentration(ChemicalEntity entity, Quantity<MolarConcentration> quantity) {
        this.concentrationContainer.setConcentration(entity, quantity);
    }

    public Map<ChemicalEntity, Quantity<MolarConcentration>> getAllConcentrations() {
        return this.concentrationContainer.getAllConcentrations();
    }

    public Map<ChemicalEntity, Quantity<MolarConcentration>> getAllConcentrationsForSection(CellSection cellSection) {
        return this.concentrationContainer.getAllConcentrationsForSection(cellSection);
    }

    public Quantity<MolarConcentration> getConcentration(ChemicalEntity entity) {
        return this.concentrationContainer.getConcentration(entity);
    }

    public void setAvailableConcentration(ChemicalEntity entity, CellSection cellSection, Quantity<MolarConcentration> quantity) {
        this.concentrationContainer.setAvailableConcentration(cellSection, entity, quantity);
    }

    public Quantity<MolarConcentration> getAvailableConcentration(ChemicalEntity entity, CellSection cellSection) {
        return this.concentrationContainer.getAvailableConcentration(cellSection, entity);
    }

    public List<Delta> getFinalDeltas() {
        return this.finalDeltas;
    }

    public void addPotentialDeltas(Collection<Delta> potentialDeltas) {
        this.potentialDeltas.addAll(potentialDeltas);
    }

    public List<Delta> getPotentialDeltas() {
        return this.potentialDeltas;
    }

    public void addPotentialDelta(Delta potentialDelta) {
        this.potentialDeltas.add(potentialDelta);
    }

    public void clearPotentialDeltas() {
        this.potentialDeltas.clear();
    }

    public void shiftDeltas() {
        this.finalDeltas.addAll(this.potentialDeltas);
        if (!this.observed) {
            this.potentialDeltas.clear();
        }
    }

    public void applyDeltas() {
        if (!this.concentrationFixed) {
            for (Delta delta : this.finalDeltas) {
                Quantity updatedConcentration = this.getAvailableConcentration(delta.getChemicalEntity(), delta.getCellSection()).add(delta.getQuantity());
                if (updatedConcentration.getValue().doubleValue() < 0.0) {
                    updatedConcentration = EnvironmentalParameters.emptyConcentration();
                }
                this.setAvailableConcentration(delta.getChemicalEntity(), delta.getCellSection(), (Quantity<MolarConcentration>)updatedConcentration);
            }
        }
        this.finalDeltas.clear();
    }

    public Set<CellSection> getAllReferencedSections() {
        return this.concentrationContainer.getAllReferencedSections();
    }

    public Set<ChemicalEntity> getAllReferencedEntities() {
        return this.concentrationContainer.getAllReferencedEntities();
    }

    public NodeState getState() {
        return this.state;
    }

    public void setState(NodeState state) {
        this.state = state;
    }

    public boolean isObserved() {
        return this.observed;
    }

    public void setObserved(boolean isObserved) {
        this.observed = isObserved;
    }

    public boolean isConcentrationFixed() {
        return this.concentrationFixed;
    }

    public void setConcentrationFixed(boolean concentrationFixed) {
        this.concentrationFixed = concentrationFixed;
    }

    public CellSection getCellSection() {
        return this.cellSection;
    }

    public void setCellSection(CellSection cellSection) {
        if (cellSection instanceof Membrane) {
            this.setState(NodeState.MEMBRANE);
        }
        this.cellSection = cellSection;
        this.concentrationContainer = new SimpleConcentrationContainer(cellSection);
        this.cellSection.addNode(this);
    }

    public ConcentrationContainer getConcentrationContainer() {
        return this.concentrationContainer;
    }

    public void setConcentrationContainer(ConcentrationContainer concentrationContainer) {
        this.concentrationContainer = concentrationContainer;
    }

    public String toString() {
        return "Node " + this.getIdentifier() + " (" + (Object)((Object)this.getState()) + ")";
    }

    public AutomatonNode getCopy() {
        throw new UnsupportedOperationException("not implemented");
    }
}

