/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.graphs;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.mathematics.graphs.grid.GridEdge;
import de.bioforscher.singa.mathematics.graphs.grid.GridGraph;
import de.bioforscher.singa.mathematics.graphs.grid.GridNode;
import de.bioforscher.singa.mathematics.graphs.model.Graphs;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.topology.grids.rectangular.RectangularCoordinate;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.compartments.EnclosedCompartment;
import de.bioforscher.singa.simulation.model.compartments.Membrane;
import de.bioforscher.singa.simulation.model.graphs.AutomatonGraph;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatonGraphs {
    private static final Logger logger = LoggerFactory.getLogger(AutomatonGraphs.class);

    private AutomatonGraphs() {
    }

    public static Map<String, ChemicalEntity> generateMapOfEntities(AutomatonGraph graph) {
        HashMap<String, ChemicalEntity> results = new HashMap<String, ChemicalEntity>();
        for (AutomatonNode node : graph.getNodes()) {
            for (ChemicalEntity entity : node.getAllReferencedEntities()) {
                results.put(entity.getIdentifier().toString(), entity);
            }
        }
        return results;
    }

    public static AutomatonGraph createRectangularAutomatonGraph(int numberOfColumns, int numberOfRows) {
        return AutomatonGraphs.useStructureFrom(Graphs.buildGridGraph((int)numberOfColumns, (int)numberOfRows));
    }

    public static AutomatonGraph useStructureFrom(GridGraph gridGraph) {
        AutomatonGraph bioGraph = new AutomatonGraph(gridGraph.getNumberOfColumns(), gridGraph.getNumberOfRows());
        for (GridNode regularNode : gridGraph.getNodes()) {
            RectangularCoordinate coordinate = (RectangularCoordinate)regularNode.getIdentifier();
            AutomatonNode bioNode = new AutomatonNode(coordinate);
            bioNode.setPosition(regularNode.getPosition());
            bioGraph.addNode((Node)bioNode);
        }
        for (GridEdge undirectedEdge : gridGraph.getEdges()) {
            int identifier = undirectedEdge.getIdentifier();
            bioGraph.addEdgeBetween(identifier, (AutomatonNode)bioGraph.getNode((RectangularCoordinate)((GridNode)undirectedEdge.getSource()).getIdentifier()), (AutomatonNode)bioGraph.getNode((RectangularCoordinate)((GridNode)undirectedEdge.getTarget()).getIdentifier()));
        }
        return bioGraph;
    }

    public static AutomatonGraph singularGraph() {
        AutomatonGraph automatonGraph = new AutomatonGraph(1, 1);
        AutomatonNode node = new AutomatonNode(new RectangularCoordinate(0, 0));
        automatonGraph.addNode((Node)node);
        return automatonGraph;
    }

    public static Membrane splitRectangularGraphWithMembrane(AutomatonGraph graph, EnclosedCompartment innerSection, CellSection outerSection) {
        logger.debug("Splitting graph in inner ({}) and outer ({}) compartment with membrane.", (Object)innerSection.getName(), (Object)outerSection.getName());
        Membrane membrane = Membrane.forCompartment(innerSection);
        int numberOfColumns = graph.getNumberOfColumns();
        for (AutomatonNode node : graph.getNodes()) {
            if (((RectangularCoordinate)node.getIdentifier()).getColumn() < numberOfColumns / 2) {
                node.setCellSection(outerSection);
                continue;
            }
            if (((RectangularCoordinate)node.getIdentifier()).getColumn() == numberOfColumns / 2) {
                node.setCellSection(membrane);
                continue;
            }
            node.setCellSection(innerSection);
        }
        graph.addCellSection(outerSection);
        graph.addCellSection(innerSection);
        graph.addCellSection(membrane);
        membrane.initializeNodes(graph);
        return membrane;
    }
}

