/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.graphs;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.features.units.UnitProvider;
import de.bioforscher.singa.mathematics.graphs.grid.AbstractGridGraph;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.graphs.AutomatonEdge;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.quantity.Quantities;

public class AutomatonGraph
extends AbstractGridGraph<AutomatonNode, AutomatonEdge, Vector2D> {
    private final Map<String, CellSection> cellSections = new HashMap<String, CellSection>();

    public AutomatonGraph(int columns, int rows) {
        super(columns, rows);
    }

    public int addEdgeBetween(int identifier, AutomatonNode source, AutomatonNode target) {
        return this.addEdgeBetween((Edge)new AutomatonEdge(identifier), (Node)source, (Node)target);
    }

    public int addEdgeBetween(AutomatonNode source, AutomatonNode target) {
        return this.addEdgeBetween(this.nextEdgeIdentifier(), source, target);
    }

    public void initializeSpeciesWithConcentration(ChemicalEntity entity, double concentration) {
        this.initializeSpeciesWithConcentration(entity, (Quantity<MolarConcentration>)Quantities.getQuantity((Number)concentration, (Unit)UnitProvider.MOLE_PER_LITRE).to(EnvironmentalParameters.getTransformedMolarConcentration()));
    }

    public void initializeSpeciesWithConcentration(ChemicalEntity entity, Quantity<MolarConcentration> concentration) {
        this.getNodes().forEach(node -> node.setConcentration(entity, concentration));
    }

    public Set<CellSection> getCellSections() {
        return new HashSet<CellSection>(this.cellSections.values());
    }

    public CellSection getCellSection(String identifier) {
        return this.cellSections.get(identifier);
    }

    public void addCellSection(CellSection cellSection) {
        this.cellSections.put(cellSection.getIdentifier(), cellSection);
    }
}

