/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.concentrations;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.measure.Quantity;

public class SimpleConcentrationContainer
implements ConcentrationContainer {
    private final Map<ChemicalEntity, Quantity<MolarConcentration>> concentrations = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>();
    private final CellSection cellSection;
    private final Set<CellSection> cellSections;

    public SimpleConcentrationContainer(CellSection cellSection) {
        this.cellSection = cellSection;
        this.cellSections = Collections.singleton(cellSection);
    }

    @Override
    public Quantity<MolarConcentration> getConcentration(ChemicalEntity chemicalEntity) {
        if (this.concentrations.containsKey(chemicalEntity)) {
            return this.concentrations.get(chemicalEntity);
        }
        this.concentrations.put(chemicalEntity, (Quantity<MolarConcentration>)EnvironmentalParameters.emptyConcentration());
        return EnvironmentalParameters.emptyConcentration();
    }

    @Override
    public Map<ChemicalEntity, Quantity<MolarConcentration>> getAllConcentrationsForSection(CellSection cellSection) {
        if (this.cellSection.equals(cellSection)) {
            return this.concentrations;
        }
        return Collections.emptyMap();
    }

    @Override
    public Quantity<MolarConcentration> getAvailableConcentration(CellSection cellSection, ChemicalEntity chemicalEntity) {
        if (this.cellSection.equals(cellSection)) {
            if (this.concentrations.containsKey(chemicalEntity)) {
                return this.getConcentration(chemicalEntity);
            }
            this.concentrations.put(chemicalEntity, (Quantity<MolarConcentration>)EnvironmentalParameters.emptyConcentration());
            return EnvironmentalParameters.emptyConcentration();
        }
        return null;
    }

    @Override
    public void setConcentration(ChemicalEntity chemicalEntity, Quantity<MolarConcentration> concentration) {
        this.concentrations.put(chemicalEntity, concentration);
    }

    @Override
    public void setAvailableConcentration(CellSection cellSection, ChemicalEntity chemicalEntity, Quantity<MolarConcentration> concentration) {
        this.setConcentration(chemicalEntity, concentration);
    }

    @Override
    public Set<ChemicalEntity> getAllReferencedEntities() {
        return this.concentrations.keySet();
    }

    @Override
    public Set<CellSection> getAllReferencedSections() {
        return this.cellSections;
    }

    @Override
    public Map<ChemicalEntity, Quantity<MolarConcentration>> getAllConcentrations() {
        return this.concentrations;
    }

    @Override
    public SimpleConcentrationContainer getCopy() {
        return new SimpleConcentrationContainer(this.cellSection);
    }
}

