/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.concentrations;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.quantity.Quantities;

public class MultiConcentrationContainer
implements ConcentrationContainer {
    private final Set<ChemicalEntity> referencedEntities;
    private final Map<CellSection, Map<ChemicalEntity, Quantity<MolarConcentration>>> concentrations;

    public MultiConcentrationContainer(Set<CellSection> cellSections) {
        this.referencedEntities = new HashSet<ChemicalEntity>();
        this.concentrations = new HashMap<CellSection, Map<ChemicalEntity, Quantity<MolarConcentration>>>();
        cellSections.forEach(compartment -> {
            Map cfr_ignored_0 = this.concentrations.put((CellSection)compartment, new HashMap());
        });
    }

    public MultiConcentrationContainer(MultiConcentrationContainer multiConcentrationContainer) {
        this.referencedEntities = multiConcentrationContainer.referencedEntities;
        this.concentrations = new HashMap<CellSection, Map<ChemicalEntity, Quantity<MolarConcentration>>>();
        Set<CellSection> cellSections = multiConcentrationContainer.concentrations.keySet();
        cellSections.forEach(compartment -> {
            Map cfr_ignored_0 = this.concentrations.put((CellSection)compartment, new HashMap());
        });
    }

    @Override
    public Quantity<MolarConcentration> getConcentration(ChemicalEntity chemicalEntity) {
        double sum = 0.0;
        long count = 0L;
        for (CellSection identifier : this.concentrations.keySet()) {
            double v = this.getAvailableConcentration(identifier, chemicalEntity).getValue().doubleValue();
            sum += v;
            ++count;
        }
        if (count > 0L) {
            return Quantities.getQuantity((Number)(sum / (double)count), (Unit)EnvironmentalParameters.getTransformedMolarConcentration());
        }
        return EnvironmentalParameters.emptyConcentration();
    }

    @Override
    public Map<ChemicalEntity, Quantity<MolarConcentration>> getAllConcentrationsForSection(CellSection cellSection) {
        if (this.concentrations.containsKey(cellSection)) {
            return this.concentrations.get(cellSection);
        }
        return Collections.emptyMap();
    }

    @Override
    public Quantity<MolarConcentration> getAvailableConcentration(CellSection cellSection, ChemicalEntity chemicalEntity) {
        if (!this.concentrations.containsKey(cellSection)) {
            return EnvironmentalParameters.emptyConcentration();
        }
        return this.concentrations.get(cellSection).get(chemicalEntity);
    }

    @Override
    public void setConcentration(ChemicalEntity chemicalEntity, Quantity<MolarConcentration> concentration) {
        this.concentrations.keySet().forEach(compartment -> this.setAvailableConcentration((CellSection)compartment, chemicalEntity, concentration));
    }

    @Override
    public void setAvailableConcentration(CellSection cellSection, ChemicalEntity chemicalEntity, Quantity<MolarConcentration> concentration) {
        this.concentrations.get(cellSection).put(chemicalEntity, concentration);
        this.referencedEntities.add(chemicalEntity);
    }

    @Override
    public Set<ChemicalEntity> getAllReferencedEntities() {
        return this.referencedEntities;
    }

    @Override
    public Set<CellSection> getAllReferencedSections() {
        return this.concentrations.keySet();
    }

    @Override
    public Map<ChemicalEntity, Quantity<MolarConcentration>> getAllConcentrations() {
        HashMap<ChemicalEntity, Quantity<MolarConcentration>> result = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>();
        for (ChemicalEntity chemicalEntity : this.referencedEntities) {
            result.put(chemicalEntity, this.getConcentration(chemicalEntity));
        }
        return result;
    }

    @Override
    public MultiConcentrationContainer getCopy() {
        return new MultiConcentrationContainer(this);
    }
}

