/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.concentrations;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.compartments.Membrane;
import de.bioforscher.singa.simulation.model.concentrations.ConcentrationContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.Quantity;

public class MembraneContainer
implements ConcentrationContainer {
    private final CellSection outerPhaseSection;
    private final CellSection innerPhaseSection;
    private final Membrane membrane;
    private Set<ChemicalEntity> referencedEntities;
    private Set<CellSection> refencedSections;
    private final Map<ChemicalEntity, Quantity<MolarConcentration>> outerPhase;
    private final Map<ChemicalEntity, Quantity<MolarConcentration>> outerLayer;
    private final Map<ChemicalEntity, Quantity<MolarConcentration>> innerLayer;
    private final Map<ChemicalEntity, Quantity<MolarConcentration>> innerPhase;

    public MembraneContainer(CellSection outerPhaseSection, CellSection innerPhaseSection, Membrane membrane) {
        this.outerPhaseSection = outerPhaseSection;
        this.innerPhaseSection = innerPhaseSection;
        this.membrane = membrane;
        this.outerPhase = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>();
        this.outerLayer = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>();
        this.innerLayer = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>();
        this.innerPhase = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>();
        this.referencedEntities = new HashSet<ChemicalEntity>();
        this.refencedSections = new HashSet<CellSection>();
    }

    public MembraneContainer(MembraneContainer container) {
        this.outerPhaseSection = container.outerPhaseSection;
        this.innerPhaseSection = container.innerPhaseSection;
        this.membrane = container.membrane;
        this.outerPhase = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>(container.outerPhase);
        this.outerLayer = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>(container.outerLayer);
        this.innerLayer = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>(container.innerLayer);
        this.innerPhase = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>(container.innerPhase);
    }

    @Override
    public Quantity<MolarConcentration> getConcentration(ChemicalEntity chemicalEntity) {
        Quantity concentrationSum = this.getAvailableConcentration(this.outerPhaseSection, chemicalEntity);
        concentrationSum = concentrationSum.add(this.getAvailableConcentration(this.innerPhaseSection, chemicalEntity));
        concentrationSum = concentrationSum.add(this.getAvailableConcentration(this.membrane.getInnerLayer(), chemicalEntity));
        concentrationSum = concentrationSum.add(this.getAvailableConcentration(this.membrane.getOuterLayer(), chemicalEntity));
        return concentrationSum.divide((Number)4.0);
    }

    public Quantity<MolarConcentration> getOuterPhaseConcentration(ChemicalEntity chemicalEntity) {
        return this.outerPhase.get(chemicalEntity);
    }

    public Quantity<MolarConcentration> getInnerPhaseConcentration(ChemicalEntity chemicalEntity) {
        return this.innerPhase.get(chemicalEntity);
    }

    public Quantity<MolarConcentration> getOuterMembraneLayerConcentration(ChemicalEntity chemicalEntity) {
        return this.outerLayer.get(chemicalEntity);
    }

    public Quantity<MolarConcentration> getInnerMembraneLayerConcentration(ChemicalEntity chemicalEntity) {
        return this.innerLayer.get(chemicalEntity);
    }

    @Override
    public Map<ChemicalEntity, Quantity<MolarConcentration>> getAllConcentrationsForSection(CellSection cellSection) {
        if (cellSection.equals(this.outerPhaseSection)) {
            return this.outerPhase;
        }
        if (cellSection.equals(this.innerPhaseSection)) {
            return this.innerPhase;
        }
        if (cellSection.equals(this.membrane)) {
            HashMap<ChemicalEntity, Quantity<MolarConcentration>> concentrations = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>();
            for (Map.Entry<ChemicalEntity, Quantity<MolarConcentration>> entry : this.innerLayer.entrySet()) {
                concentrations.put(entry.getKey(), (Quantity<MolarConcentration>)entry.getValue().add(this.outerLayer.get(entry.getKey())).divide((Number)2.0));
            }
            return concentrations;
        }
        if (cellSection.equals(this.membrane.getInnerLayer())) {
            return this.innerLayer;
        }
        if (cellSection.equals(this.membrane.getOuterLayer())) {
            return this.outerLayer;
        }
        return Collections.emptyMap();
    }

    @Override
    public Quantity<MolarConcentration> getAvailableConcentration(CellSection cellSection, ChemicalEntity chemicalEntity) {
        Quantity<MolarConcentration> concentration = null;
        if (cellSection.equals(this.outerPhaseSection)) {
            concentration = this.getOuterPhaseConcentration(chemicalEntity);
        } else if (cellSection.equals(this.innerPhaseSection)) {
            concentration = this.getInnerPhaseConcentration(chemicalEntity);
        } else if (cellSection.equals(this.membrane)) {
            concentration = this.getInnerMembraneLayerConcentration(chemicalEntity).add(this.getOuterMembraneLayerConcentration(chemicalEntity)).divide((Number)2.0);
        } else if (cellSection.equals(this.membrane.getInnerLayer())) {
            concentration = this.getInnerMembraneLayerConcentration(chemicalEntity);
        } else if (cellSection.equals(this.membrane.getOuterLayer())) {
            concentration = this.getOuterMembraneLayerConcentration(chemicalEntity);
        }
        if (concentration == null) {
            return EnvironmentalParameters.emptyConcentration();
        }
        return concentration;
    }

    @Override
    public void setConcentration(ChemicalEntity chemicalEntity, Quantity<MolarConcentration> concentration) {
        this.outerPhase.put(chemicalEntity, concentration);
        this.outerLayer.put(chemicalEntity, concentration);
        this.innerLayer.put(chemicalEntity, concentration);
        this.innerPhase.put(chemicalEntity, concentration);
    }

    @Override
    public void setAvailableConcentration(CellSection cellSection, ChemicalEntity chemicalEntity, Quantity<MolarConcentration> concentration) {
        if (cellSection.equals(this.outerPhaseSection)) {
            this.outerPhase.put(chemicalEntity, concentration);
        } else if (cellSection.equals(this.innerPhaseSection)) {
            this.innerPhase.put(chemicalEntity, concentration);
        } else if (cellSection.equals(this.membrane)) {
            this.innerLayer.put(chemicalEntity, concentration);
            this.outerLayer.put(chemicalEntity, concentration);
        } else if (cellSection.equals(this.membrane.getInnerLayer())) {
            this.innerLayer.put(chemicalEntity, concentration);
        } else if (cellSection.equals(this.membrane.getOuterLayer())) {
            this.outerLayer.put(chemicalEntity, concentration);
        }
    }

    @Override
    public Set<ChemicalEntity> getAllReferencedEntities() {
        return this.referencedEntities;
    }

    public void setReferencedEntities(Set<ChemicalEntity> referencedEntities) {
        this.referencedEntities = referencedEntities;
    }

    @Override
    public Set<CellSection> getAllReferencedSections() {
        return this.refencedSections;
    }

    public void setRefencedSections(Set<CellSection> refencedSections) {
        this.refencedSections = refencedSections;
    }

    public Membrane getMembrane() {
        return this.membrane;
    }

    public CellSection getOuterPhaseSection() {
        return this.outerPhaseSection;
    }

    public CellSection getOuterLayerSection() {
        return this.membrane.getOuterLayer();
    }

    public CellSection getInnerLayerSection() {
        return this.membrane.getInnerLayer();
    }

    public CellSection getInnerPhaseSection() {
        return this.innerPhaseSection;
    }

    @Override
    public Map<ChemicalEntity, Quantity<MolarConcentration>> getAllConcentrations() {
        HashMap<ChemicalEntity, Quantity<MolarConcentration>> result = new HashMap<ChemicalEntity, Quantity<MolarConcentration>>();
        for (ChemicalEntity chemicalEntity : this.getAllReferencedEntities()) {
            result.put(chemicalEntity, this.getConcentration(chemicalEntity));
        }
        return result;
    }

    @Override
    public MembraneContainer getCopy() {
        return new MembraneContainer(this);
    }
}

