/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.compartments;

import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.compartments.EnclosedCompartment;
import de.bioforscher.singa.simulation.model.concentrations.MembraneContainer;
import de.bioforscher.singa.simulation.model.graphs.AutomatonGraph;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import java.util.Set;
import java.util.stream.Collectors;

public class Membrane
extends CellSection {
    private final EnclosedCompartment innerCompartment;
    private final CellSection innerLayer;
    private final CellSection outerLayer;

    public Membrane(String identifier, String name, EnclosedCompartment innerCompartment) {
        super(identifier, name);
        this.innerCompartment = innerCompartment;
        this.innerLayer = new EnclosedCompartment(identifier + "I", name + " Inner Layer");
        this.innerLayer.setSubsection(true);
        this.outerLayer = new EnclosedCompartment(identifier + "O", name + " Outer Layer");
        this.innerLayer.setSubsection(true);
    }

    public static Membrane forCompartment(EnclosedCompartment enclosedCompartment) {
        return new Membrane(enclosedCompartment.getIdentifier() + "-M", enclosedCompartment.getName() + " Membrane", enclosedCompartment);
    }

    public EnclosedCompartment getInnerCompartment() {
        return this.innerCompartment;
    }

    public CellSection getInnerLayer() {
        return this.innerLayer;
    }

    public CellSection getOuterLayer() {
        return this.outerLayer;
    }

    public void initializeNodes(AutomatonGraph automatonGraph) {
        for (AutomatonNode node : this.getContent()) {
            Set sections = node.getNeighbours().stream().map(AutomatonNode::getCellSection).filter(cellSection -> !cellSection.equals(this.innerCompartment) && !cellSection.equals(this)).collect(Collectors.toSet());
            if (sections.size() != 1) {
                throw new IllegalStateException("The node " + (Object)((Object)node) + " is considered as a membrane node but has neighbours in more than 3 states (inner section, outer section, membrane section)");
            }
            node.setConcentrationContainer(new MembraneContainer((CellSection)sections.iterator().next(), this.innerCompartment, this));
        }
    }
}

