/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.compartments;

import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.compartments.Membrane;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnclosedCompartment
extends CellSection {
    private static final Logger logger = LoggerFactory.getLogger(EnclosedCompartment.class);
    private Membrane enclosingMembrane;

    public EnclosedCompartment(String identifier, String name) {
        super(identifier, name);
    }

    private boolean isInThisCompartment(AutomatonNode node) {
        return node.getCellSection().getIdentifier().equals(this.getIdentifier());
    }

    private boolean hasNeighbourInOtherCompartment(AutomatonNode node) {
        for (AutomatonNode neighbour : node.getNeighbours()) {
            if (this.isInThisCompartment(neighbour)) continue;
            return true;
        }
        return false;
    }

    private boolean isNewBorder(LinkedList<AutomatonNode> oldNodes, AutomatonNode currentNode) {
        return this.isInThisCompartment(currentNode) && !oldNodes.contains((Object)currentNode) && this.hasNeighbourInOtherCompartment(currentNode);
    }

    public Membrane getEnclosingMembrane() {
        return this.enclosingMembrane;
    }

    public void setEnclosingMembrane(Membrane enclosingMembrane) {
        this.enclosingMembrane = enclosingMembrane;
    }
}

