/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.model.compartments;

import de.bioforscher.singa.core.utility.Nameable;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import java.util.HashSet;
import java.util.Set;

public abstract class CellSection
implements Nameable {
    private final String identifier;
    private final String name;
    private boolean isSubsection;
    private Set<AutomatonNode> content;

    public CellSection(String identifier, String name) {
        this.identifier = identifier;
        this.name = name;
        this.content = new HashSet<AutomatonNode>();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public Set<AutomatonNode> getContent() {
        return this.content;
    }

    public void setContent(Set<AutomatonNode> content) {
        this.content = content;
    }

    public void addNode(AutomatonNode node) {
        this.content.add(node);
    }

    public boolean isSubsection() {
        return this.isSubsection;
    }

    public void setSubsection(boolean subsection) {
        this.isSubsection = subsection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellSection that = (CellSection)o;
        return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
    }

    public int hashCode() {
        return this.identifier != null ? this.identifier.hashCode() : 0;
    }

    public String toString() {
        return "CellSection{identifier='" + this.identifier + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

