/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.features.scale;

import de.bioforscher.singa.features.model.AbstractFeature;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.features.model.ScalableFeature;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.Units;

public class AppliedScale
extends AbstractFeature<Double>
implements ScalableFeature<Double> {
    public static final String SYMBOL = "scale";
    private Double scaledQuantity;
    private Double halfScaledQuantity;
    private Quantity<Time> previousTimeStep;

    public AppliedScale(Double scale, FeatureOrigin featureOrigin) {
        super((Object)scale, featureOrigin);
    }

    public AppliedScale() {
        super((Object)1.0, FeatureOrigin.MANUALLY_ANNOTATED);
    }

    public void scale(Quantity<Time> time, Quantity<Length> space) {
        if (this.previousTimeStep != null) {
            double scale = time.to(MetricPrefix.MILLI((Unit)Units.SECOND)).getValue().doubleValue() / this.previousTimeStep.to(MetricPrefix.MILLI((Unit)Units.SECOND)).getValue().doubleValue();
            this.scaledQuantity = this.scaledQuantity * scale;
            this.halfScaledQuantity = this.scaledQuantity * 0.5;
        } else {
            this.scaledQuantity = 1.0;
            this.halfScaledQuantity = 0.5;
        }
        this.previousTimeStep = time;
    }

    public Double getScaledQuantity() {
        return this.scaledQuantity;
    }

    public Double getHalfScaledQuantity() {
        return this.halfScaledQuantity;
    }

    public String getSymbol() {
        return SYMBOL;
    }
}

