/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.features.permeability;

import de.bioforscher.singa.features.model.AbstractFeature;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.features.model.ScalableFeature;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import tec.uom.se.AbstractUnit;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.Units;

public class MembraneEntry
extends AbstractFeature<Quantity<Frequency>>
implements ScalableFeature<Quantity<Frequency>> {
    public static final String SYMBOL = "k_in";
    private Quantity<Frequency> scaledQuantity;
    private Quantity<Frequency> halfScaledQuantity;

    public MembraneEntry(Quantity<Frequency> frequencyQuantity, FeatureOrigin featureOrigin) {
        super(frequencyQuantity, featureOrigin);
    }

    public MembraneEntry(double frequency, FeatureOrigin featureOrigin) {
        super((Object)Quantities.getQuantity((Number)frequency, (Unit)Units.HERTZ), featureOrigin);
    }

    public void scale(Quantity<Time> time, Quantity<Length> space) {
        Quantity scaledQuantity = ((Quantity)this.getFeatureContent()).to((Unit)new ProductUnit(AbstractUnit.ONE.divide(time.getUnit())));
        this.scaledQuantity = scaledQuantity.multiply((Number)time.getValue().doubleValue());
        this.halfScaledQuantity = scaledQuantity.multiply((Number)time.multiply((Number)0.5).getValue().doubleValue());
    }

    public Quantity<Frequency> getScaledQuantity() {
        return this.scaledQuantity;
    }

    public Quantity<Frequency> getHalfScaledQuantity() {
        return this.halfScaledQuantity;
    }

    public String getSymbol() {
        return SYMBOL;
    }
}

