/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.simulation.events;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.core.events.UpdateEventListener;
import de.bioforscher.singa.features.model.QuantityFormatter;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import de.bioforscher.singa.features.quantities.MolarConcentration;
import de.bioforscher.singa.features.units.UnitProvider;
import de.bioforscher.singa.simulation.events.NodeUpdatedEvent;
import de.bioforscher.singa.simulation.model.compartments.CellSection;
import de.bioforscher.singa.simulation.model.graphs.AutomatonNode;
import de.bioforscher.singa.simulation.modules.model.Delta;
import de.bioforscher.singa.simulation.modules.model.Module;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.Units;

public class EpochUpdateWriter
implements UpdateEventListener<NodeUpdatedEvent> {
    private static final char COMMENT_CHARACTER = '#';
    private static final char SEPARATOR_CHARACTER = ',';
    private static final char SECTION_SPACER = '.';
    private static final String LINEBREAK = System.getProperty("line.separator");
    private final Path workspacePath;
    private final Path folder;
    private final boolean printHeader;
    private final Map<AutomatonNode, BufferedWriter> concentrationWriters;
    private final Map<AutomatonNode, BufferedWriter> deltaWriters;
    private final List<ChemicalEntity> observedEntities;
    private final List<Module> observedModules;
    private QuantityFormatter<Time> timeFormatter = new QuantityFormatter(MetricPrefix.MILLI((Unit)Units.SECOND), false);
    private QuantityFormatter<MolarConcentration> concentrationFormatter = new QuantityFormatter(UnitProvider.MOLE_PER_LITRE, false);

    public EpochUpdateWriter(Path workspacePath, Path folder, Set<ChemicalEntity> entitiesToObserve, Set<Module> modulesToObserve) {
        this(workspacePath, folder, entitiesToObserve, modulesToObserve, true);
    }

    public EpochUpdateWriter(Path workspacePath, Path folder, Set<ChemicalEntity> entitiesToObserve, Set<Module> modulesToObserve, boolean printHeader) {
        this.workspacePath = workspacePath;
        this.folder = folder;
        this.createFolderStructure();
        this.observedEntities = EpochUpdateWriter.initializeOrdering(entitiesToObserve);
        this.observedModules = EpochUpdateWriter.initializeOrdering(modulesToObserve);
        this.printHeader = printHeader;
        this.concentrationWriters = new HashMap<AutomatonNode, BufferedWriter>();
        this.deltaWriters = new HashMap<AutomatonNode, BufferedWriter>();
    }

    private static <ValueType> List<ValueType> initializeOrdering(Set<ValueType> unorderedEntities) {
        return new ArrayList<ValueType>(unorderedEntities);
    }

    private void createFolderStructure() {
        Path workspaceFolder = this.workspacePath.resolve(this.folder);
        try {
            if (!Files.exists(workspaceFolder, new LinkOption[0])) {
                Files.createDirectory(workspaceFolder, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Path createFile(String fileName) {
        Path file = this.workspacePath.resolve(this.folder).resolve(fileName);
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public void addNodeToObserve(AutomatonNode node) throws IOException {
        Path concentrationFile = this.createFile("node_" + node.getIdentifier() + "_concentrations.csv");
        BufferedWriter concentrationWriter = Files.newBufferedWriter(concentrationFile, new OpenOption[0]);
        this.concentrationWriters.put(node, concentrationWriter);
        this.writeConcentrationFileHeader(node);
        Path deltaFile = this.createFile("node_" + node.getIdentifier() + "_deltas.csv");
        BufferedWriter deltaWriter = Files.newBufferedWriter(deltaFile, new OpenOption[0]);
        this.deltaWriters.put(node, deltaWriter);
        this.writeDeltaFileHeader(node);
    }

    private void writeDeltaFileHeader(AutomatonNode node) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.printHeader) {
            sb.append('#').append(" Node ").append(node.getIdentifier()).append(LINEBREAK);
        }
        sb.append(this.prepareDeltaColumnHeader());
        this.appendDeltaContent(node, sb.toString());
    }

    private String prepareDeltaColumnHeader() {
        return "elapsed_time,time_step_size,module,chemical_entity,cell_section,delta,delta_adjusted" + LINEBREAK;
    }

    private void writeConcentrationFileHeader(AutomatonNode node) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.printHeader) {
            sb.append('#').append(" Node ").append(node.getIdentifier()).append(LINEBREAK).append(this.prepareEntityInformation());
        }
        sb.append(this.prepareConcentrationColumnHeader(node));
        this.appendConcentrationContent(node, sb.toString());
    }

    private String prepareEntityInformation() {
        StringBuilder sb = new StringBuilder();
        for (ChemicalEntity entity : this.observedEntities) {
            sb.append('#').append(" ").append(entity.getName()).append(" ").append(entity.getIdentifier()).append(LINEBREAK);
        }
        return sb.toString();
    }

    private String prepareConcentrationColumnHeader(AutomatonNode node) {
        Set<CellSection> referencedSections = node.getAllReferencedSections();
        StringBuilder sb = new StringBuilder();
        sb.append("elapsed time").append(',');
        int count = 0;
        int size = this.observedEntities.size() * referencedSections.size() - 1;
        for (ChemicalEntity entity : this.observedEntities) {
            for (CellSection cellSection : referencedSections) {
                if (count < size) {
                    sb.append(entity.getIdentifier()).append('.').append(cellSection.getIdentifier()).append(',');
                } else {
                    sb.append(entity.getIdentifier()).append('.').append(cellSection.getIdentifier()).append(LINEBREAK);
                }
                ++count;
            }
        }
        return sb.toString();
    }

    private void appendConcentrationContent(AutomatonNode node, String content) throws IOException {
        this.concentrationWriters.get((Object)node).write(content);
    }

    private void appendDeltaContent(AutomatonNode node, String content) throws IOException {
        this.deltaWriters.get((Object)node).write(content);
    }

    public void closeWriters() {
        for (BufferedWriter bufferedWriter : this.concentrationWriters.values()) {
            try {
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (BufferedWriter bufferedWriter : this.deltaWriters.values()) {
            try {
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void onEventReceived(NodeUpdatedEvent event) {
        this.appendConcentrationContent(event);
        this.appendDeltaContent(event);
    }

    private void appendConcentrationContent(NodeUpdatedEvent event) {
        AutomatonNode node = event.getNode();
        Set<CellSection> referencedSections = node.getAllReferencedSections();
        StringBuilder sb = new StringBuilder();
        sb.append(this.timeFormatter.format(event.getTime())).append(',');
        int count = 0;
        int size = this.observedEntities.size() * referencedSections.size() - 1;
        for (ChemicalEntity entity : this.observedEntities) {
            for (CellSection cellSection : referencedSections) {
                if (count < size) {
                    sb.append(this.concentrationFormatter.format(node.getAvailableConcentration(entity, cellSection))).append(',');
                } else {
                    sb.append(this.concentrationFormatter.format(node.getAvailableConcentration(entity, cellSection))).append(LINEBREAK);
                }
                ++count;
            }
        }
        try {
            this.appendConcentrationContent(node, sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void appendDeltaContent(NodeUpdatedEvent event) {
        AutomatonNode node = event.getNode();
        StringBuilder sb = new StringBuilder();
        for (Delta delta : node.getPotentialDeltas()) {
            if (!this.observedModules.contains(delta.getModule()) || !this.observedEntities.contains(delta.getChemicalEntity())) continue;
            sb.append(this.timeFormatter.format(event.getTime())).append(',').append(EnvironmentalParameters.getTimeStep().getValue().doubleValue()).append(',').append(delta.getModule()).append(',').append(delta.getChemicalEntity().getIdentifier()).append(',').append(delta.getCellSection().getIdentifier()).append(',').append(EnvironmentalParameters.DELTA_FORMATTER.format(delta.getQuantity())).append(',').append(delta.getQuantity().to(UnitProvider.MOLE_PER_LITRE).getValue().doubleValue() / EnvironmentalParameters.getTimeStep().getValue().doubleValue()).append(LINEBREAK);
        }
        try {
            this.appendDeltaContent(node, sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

