/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.sequence.model;

import de.bioforscher.singa.sequence.model.AbstractSequence;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.interfaces.AminoAcid;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructureContainer;
import de.bioforscher.singa.structure.model.oak.Exchangeable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ProteinSequence
extends AbstractSequence<AminoAcidFamily> {
    public ProteinSequence(List<AminoAcidFamily> sequence) {
        super(sequence);
    }

    public static ProteinSequence of(List<LeafSubstructure<?>> leafSubstructures) {
        List<AminoAcidFamily> sequence = leafSubstructures.stream().filter(AminoAcid.class::isInstance).map(AminoAcid.class::cast).map(Exchangeable::getFamily).collect(Collectors.toList());
        return new ProteinSequence(sequence);
    }

    public static ProteinSequence of(LeafSubstructureContainer leafSubstructureContainer) {
        List<AminoAcidFamily> sequence = leafSubstructureContainer.getAllAminoAcids().stream().map(Exchangeable::getFamily).collect(Collectors.toList());
        return new ProteinSequence(sequence);
    }

    public static ProteinSequence of(String sequence) {
        ArrayList<AminoAcidFamily> aminoAcidList = new ArrayList<AminoAcidFamily>();
        for (char c : sequence.toCharArray()) {
            aminoAcidList.add(AminoAcidFamily.getAminoAcidTypeByOneLetterCode((char)c).orElse(AminoAcidFamily.UNKNOWN));
        }
        return new ProteinSequence((List<AminoAcidFamily>)aminoAcidList);
    }
}

