/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.sequence.algorithms.alignment;

import de.bioforscher.singa.mathematics.algorithms.graphs.ShortestPathFinder;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.GraphPath;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.sequence.algorithms.alignment.DynamicProgrammingEdge;
import de.bioforscher.singa.sequence.algorithms.alignment.DynamicProgrammingGraph;
import de.bioforscher.singa.sequence.algorithms.alignment.DynamicProgrammingNode;
import de.bioforscher.singa.sequence.model.ProteinSequence;
import de.bioforscher.singa.structure.algorithms.superimposition.scores.SubstitutionMatrix;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.families.StructuralFamily;
import java.util.Collections;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeedlemanWunschAlignment {
    private static final Logger logger = LoggerFactory.getLogger(NeedlemanWunschAlignment.class);
    private static final int DEFAULT_GAP_COST = -8;
    private int gapCost = -8;
    private final LabeledSymmetricMatrix<StructuralFamily> substitutionMatrix;
    private DynamicProgrammingGraph graph;
    private ProteinSequence alignedFirstSequence;
    private ProteinSequence alignedSecondSequence;

    public NeedlemanWunschAlignment(SubstitutionMatrix substitutionMatrix, ProteinSequence firstSequence, ProteinSequence secondSequence) {
        this.substitutionMatrix = substitutionMatrix.getMatrix();
        this.graph = new DynamicProgrammingGraph(firstSequence, secondSequence);
        logger.info("Computing alignment using Neddleman Wunsch for sequences:\n {} \n {}", (Object)firstSequence, (Object)secondSequence);
        this.initialize();
        this.fillMatrix();
        this.backTrack();
    }

    public DynamicProgrammingGraph getGraph() {
        return this.graph;
    }

    public int getGapCost() {
        return this.gapCost;
    }

    public void setGapCost(int gapCost) {
        this.gapCost = gapCost;
    }

    public double getScore() {
        return this.graph.getNode(this.graph.getFirstSequenceLength(), this.graph.getSecondSequenceLength()).getScore();
    }

    public ProteinSequence getAlignedFirstSequence() {
        return this.alignedFirstSequence;
    }

    public ProteinSequence getAlignedSecondSequence() {
        return this.alignedSecondSequence;
    }

    private void initialize() {
        DynamicProgrammingNode currentNode;
        double score;
        DynamicProgrammingNode initialNode = new DynamicProgrammingNode(this.graph.nextNodeIdentifier());
        this.graph.addNode(initialNode, 0, 0);
        DynamicProgrammingNode previousNode = initialNode;
        for (int firstSequenceIndex = 0; firstSequenceIndex < this.graph.getFirstSequence().getSequence().size(); ++firstSequenceIndex) {
            score = firstSequenceIndex * this.gapCost;
            currentNode = new DynamicProgrammingNode(this.graph.nextNodeIdentifier());
            currentNode.setScore(score);
            this.graph.addNode(currentNode, firstSequenceIndex + 1, 0);
            this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, (AminoAcidFamily)this.getGraph().getFirstSequence().getLetter(firstSequenceIndex), AminoAcidFamily.GAP), (Node)currentNode, (Node)previousNode);
            previousNode = currentNode;
        }
        previousNode = initialNode;
        for (int secondSequenceIndex = 0; secondSequenceIndex < this.graph.getSecondSequence().getSequence().size(); ++secondSequenceIndex) {
            score = secondSequenceIndex * this.gapCost;
            currentNode = new DynamicProgrammingNode(this.graph.nextNodeIdentifier());
            currentNode.setScore(score);
            this.graph.addNode(currentNode, 0, secondSequenceIndex + 1);
            this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, AminoAcidFamily.GAP, (AminoAcidFamily)this.getGraph().getSecondSequence().getLetter(secondSequenceIndex)), (Node)currentNode, (Node)previousNode);
            previousNode = currentNode;
        }
        logger.debug("Initialized dynamic programming matrix.");
    }

    private void fillMatrix() {
        for (int firstIndex = 1; firstIndex < this.getGraph().getFirstSequenceLength() + 1; ++firstIndex) {
            for (int secondIndex = 1; secondIndex < this.getGraph().getSecondSequenceLength() + 1; ++secondIndex) {
                this.determineMatrixElement(firstIndex, secondIndex);
            }
        }
        logger.debug("Calculated alignment sores and paths.");
    }

    private void determineMatrixElement(int i, int j) {
        DynamicProgrammingNode currentNode = new DynamicProgrammingNode(this.graph.nextNodeIdentifier());
        this.graph.addNode(currentNode, i, j);
        AminoAcidFamily firstLetter = (AminoAcidFamily)this.graph.getFirstSequence().getLetter(i - 1);
        AminoAcidFamily secondLetter = (AminoAcidFamily)this.graph.getSecondSequence().getLetter(j - 1);
        DynamicProgrammingNode diagonalNode = this.graph.getNode(i - 1, j - 1);
        DynamicProgrammingNode leftNode = this.graph.getNode(i - 1, j);
        DynamicProgrammingNode upperNode = this.graph.getNode(i, j - 1);
        double substitutionScore = this.substitutionMatrix.getValueForLabel((Object)firstLetter, (Object)secondLetter);
        double diagonalScore = diagonalNode.getScore() + substitutionScore;
        double leftScore = leftNode.getScore() + (double)this.gapCost;
        double upperScore = upperNode.getScore() + (double)this.gapCost;
        if (diagonalScore == upperScore) {
            if (diagonalScore == leftScore) {
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), substitutionScore, firstLetter, secondLetter), (Node)currentNode, (Node)diagonalNode);
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, AminoAcidFamily.GAP, secondLetter), (Node)currentNode, (Node)upperNode);
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, firstLetter, AminoAcidFamily.GAP), (Node)currentNode, (Node)leftNode);
                currentNode.setScore(diagonalScore);
            } else if (diagonalScore > leftScore) {
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), substitutionScore, firstLetter, secondLetter), (Node)currentNode, (Node)diagonalNode);
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, AminoAcidFamily.GAP, secondLetter), (Node)currentNode, (Node)upperNode);
                currentNode.setScore(diagonalScore);
            } else {
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, firstLetter, AminoAcidFamily.GAP), (Node)currentNode, (Node)leftNode);
                currentNode.setScore(leftScore);
            }
        } else if (diagonalScore < upperScore) {
            if (upperScore == leftScore) {
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, AminoAcidFamily.GAP, secondLetter), (Node)currentNode, (Node)upperNode);
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, firstLetter, AminoAcidFamily.GAP), (Node)currentNode, (Node)leftNode);
                currentNode.setScore(upperScore);
            } else if (upperScore > leftScore) {
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, AminoAcidFamily.GAP, secondLetter), (Node)currentNode, (Node)upperNode);
                currentNode.setScore(upperScore);
            } else {
                this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, firstLetter, AminoAcidFamily.GAP), (Node)currentNode, (Node)leftNode);
                currentNode.setScore(leftScore);
            }
        } else if (upperScore == leftScore) {
            this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), substitutionScore, firstLetter, secondLetter), (Node)currentNode, (Node)diagonalNode);
            currentNode.setScore(diagonalScore);
        } else if (diagonalScore == leftScore) {
            this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), substitutionScore, firstLetter, secondLetter), (Node)currentNode, (Node)diagonalNode);
            this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, firstLetter, AminoAcidFamily.GAP), (Node)currentNode, (Node)leftNode);
            currentNode.setScore(diagonalScore);
        } else if (diagonalScore > leftScore) {
            this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), substitutionScore, firstLetter, secondLetter), (Node)currentNode, (Node)diagonalNode);
            currentNode.setScore(diagonalScore);
        } else {
            this.graph.addEdgeBetween((Edge)new DynamicProgrammingEdge(this.graph.nextEdgeIdentifier(), this.gapCost, firstLetter, AminoAcidFamily.GAP), (Node)currentNode, (Node)leftNode);
            currentNode.setScore(leftScore);
        }
    }

    private void backTrack() {
        DynamicProgrammingNode lastNode = this.graph.getNode(this.graph.getFirstSequenceLength(), this.graph.getSecondSequenceLength());
        GraphPath path = ShortestPathFinder.findBasedOnPredicate((Graph)this.graph, (Node)lastNode, node -> (Integer)node.getIdentifier() == 0);
        Collections.reverse(path.getEdges());
        this.alignedFirstSequence = new ProteinSequence(path.getEdges().stream().map(DynamicProgrammingEdge::getFirst).collect(Collectors.toList()));
        this.alignedSecondSequence = new ProteinSequence(path.getEdges().stream().map(DynamicProgrammingEdge::getSecond).collect(Collectors.toList()));
        logger.debug("Backtracked optimal alignment with score {} :\n {} \n {}", new Object[]{lastNode.getScore(), this.alignedFirstSequence, this.alignedSecondSequence});
    }
}

