/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.sequence.algorithms.alignment;

import de.bioforscher.singa.core.utility.Pair;
import de.bioforscher.singa.mathematics.graphs.model.DirectedWeightedGraph;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.sequence.algorithms.alignment.DynamicProgrammingEdge;
import de.bioforscher.singa.sequence.algorithms.alignment.DynamicProgrammingNode;
import de.bioforscher.singa.sequence.model.ProteinSequence;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;

public class DynamicProgrammingGraph
extends DirectedWeightedGraph<DynamicProgrammingNode, DynamicProgrammingEdge> {
    private ProteinSequence firstSequence;
    private ProteinSequence secondSequence;
    private DynamicProgrammingNode[][] nodes;

    public DynamicProgrammingGraph(ProteinSequence firstSequence, ProteinSequence secondSequence) {
        this.firstSequence = firstSequence;
        this.secondSequence = secondSequence;
        this.nodes = new DynamicProgrammingNode[firstSequence.getLength() + 1][secondSequence.getLength() + 1];
    }

    public Integer addNode(DynamicProgrammingNode node, int firstIndex, int secondIndex) {
        node.setPosition((Vector)new Vector2D(10.0 + (double)firstIndex * 25.0, 10.0 + (double)secondIndex * 25.0));
        this.nodes[firstIndex][secondIndex] = node;
        return (Integer)super.addNode((Node)node);
    }

    public DynamicProgrammingNode getNode(int firstIndex, int secondIndex) {
        return this.nodes[firstIndex][secondIndex];
    }

    public Pair<AminoAcidFamily> getParing(int firstIndex, int secondIndex) {
        return new Pair(this.firstSequence.getLetter(firstIndex), this.secondSequence.getLetter(secondIndex));
    }

    public ProteinSequence getFirstSequence() {
        return this.firstSequence;
    }

    public int getFirstSequenceLength() {
        return this.firstSequence.getLength();
    }

    public ProteinSequence getSecondSequence() {
        return this.secondSequence;
    }

    public int getSecondSequenceLength() {
        return this.secondSequence.getLength();
    }

    public int addEdgeBetween(int identifier, DynamicProgrammingNode source, DynamicProgrammingNode target) {
        return this.addEdgeBetween((Edge)new DynamicProgrammingEdge(identifier), (Node)source, (Node)target);
    }

    public int addEdgeBetween(DynamicProgrammingNode source, DynamicProgrammingNode target) {
        return this.addEdgeBetween((int)this.nextNodeIdentifier(), source, target);
    }

    public int addEdgeBetween(int identifier, double weight, DynamicProgrammingNode source, DynamicProgrammingNode target) {
        return this.addEdgeBetween((Edge)new DynamicProgrammingEdge(identifier, weight), (Node)source, (Node)target);
    }
}

