/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.vectors;

import de.bioforscher.singa.mathematics.concepts.Addable;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.concurrent.ThreadLocalRandom;

public class Vectors {
    private Vectors() {
    }

    public static boolean haveSameDimension(Collection<Vector> vectors) {
        Iterator<Vector> iterator = vectors.iterator();
        int requiredDimension = iterator.next().getDimension();
        while (iterator.hasNext()) {
            if (requiredDimension == iterator.next().getDimension()) continue;
            return false;
        }
        return true;
    }

    public static List<Vector2D> generateMultipleRandom2DVectors(int numberOfVcetors, Rectangle rectangle) {
        ArrayList<Vector2D> vectors = new ArrayList<Vector2D>(numberOfVcetors);
        for (int i = 0; i < numberOfVcetors; ++i) {
            vectors.add(Vectors.generateRandom2DVector(rectangle));
        }
        return vectors;
    }

    public static Vector2D generateRandom2DVector(Rectangle rectangle) {
        double x = ThreadLocalRandom.current().nextDouble(rectangle.getLeftMostXPosition(), rectangle.getRightMostXPosition());
        double y = ThreadLocalRandom.current().nextDouble(rectangle.getBottomMostYPosition(), rectangle.getTopMostYPosition());
        return new Vector2D(x, y);
    }

    public static Vector3D generateRandomVector3D() {
        double x = ThreadLocalRandom.current().nextDouble();
        double y = ThreadLocalRandom.current().nextDouble();
        double z = ThreadLocalRandom.current().nextDouble();
        return new Vector3D(x, y, z);
    }

    public static double getAverage(Vector vector) {
        OptionalDouble optionalAverage = vector.streamElements().average();
        if (optionalAverage.isPresent()) {
            return optionalAverage.getAsDouble();
        }
        return Double.NaN;
    }

    public static double getMedian(Vector vector) {
        double[] elements = vector.getCopy().getElements();
        Arrays.sort(elements);
        if (elements.length % 2 == 0) {
            return (elements[elements.length / 2 - 1] + elements[elements.length / 2]) / 2.0;
        }
        return elements[elements.length / 2];
    }

    public static double getStandardDeviation(Vector vector) {
        double mean = Vectors.getAverage(vector);
        double dv = 0.0;
        for (double d : vector.getElements()) {
            double dm = d - mean;
            dv += dm * dm;
        }
        return Math.sqrt(dv / (double)(vector.getDimension() - 1));
    }

    public static double getVariance(Vector vector) {
        double standardDeviation = Vectors.getStandardDeviation(vector);
        return standardDeviation * standardDeviation;
    }

    public static double getMaximalValueForIndex(int index, Vector ... vectors) {
        double maximalValue = -1.7976931348623157E308;
        for (Vector vector : vectors) {
            if (!(vector.getElement(index) > maximalValue)) continue;
            maximalValue = vector.getElement(index);
        }
        return maximalValue;
    }

    public static double getMinimalValueForIndex(int index, Vector ... vectors) {
        double minimalValue = Double.MAX_VALUE;
        for (Vector vector : vectors) {
            if (!(vector.getElement(index) < minimalValue)) continue;
            minimalValue = vector.getElement(index);
        }
        return minimalValue;
    }

    public static int getIndexWithMaximalElement(Vector vector) {
        int maximalIndex = -1;
        double maximalValue = -1.7976931348623157E308;
        for (int index = 0; index < vector.getDimension(); ++index) {
            double currentValue = vector.getElement(index);
            if (!(currentValue > maximalValue)) continue;
            maximalValue = currentValue;
            maximalIndex = index;
        }
        return maximalIndex;
    }

    public static int getIndexWithMinimalElement(Vector vector) {
        int minimalIndex = -1;
        double minimalValue = Double.MAX_VALUE;
        for (int index = 0; index < vector.getDimension(); ++index) {
            double currentValue = vector.getElement(index);
            if (!(currentValue < minimalValue)) continue;
            minimalValue = currentValue;
            minimalIndex = index;
        }
        return minimalIndex;
    }

    public static int getIndexWithAbsoluteMaximalElement(Vector vector) {
        int maximalIndex = -1;
        double maximalValue = -1.7976931348623157E308;
        for (int index = 0; index < vector.getDimension(); ++index) {
            double currentValue = Math.abs(vector.getElement(index));
            if (!(currentValue > maximalValue)) continue;
            maximalValue = currentValue;
            maximalIndex = index;
        }
        return maximalIndex;
    }

    public static int getIndexWithAbsoluteMinimalElement(Vector vector) {
        int minimalIndex = -1;
        double minimalValue = Double.MAX_VALUE;
        for (int index = 0; index < vector.getDimension(); ++index) {
            double currentValue = Math.abs(vector.getElement(index));
            if (!(currentValue < minimalValue)) continue;
            minimalValue = currentValue;
            minimalIndex = index;
        }
        return minimalIndex;
    }

    public static <VectorType extends Vector> List<VectorType> getVectorsWithMinimalValueForIndex(List<VectorType> vectors, int index) {
        if (vectors.size() == 1) {
            return vectors;
        }
        double minimalValue = Double.MAX_VALUE;
        ArrayList<Vector> minimalVectors = new ArrayList<Vector>();
        for (Vector vector : vectors) {
            double currentValue = vector.getElement(index);
            if (Double.compare(currentValue, minimalValue) == 0) {
                minimalVectors.add(vector);
                continue;
            }
            if (Double.compare(currentValue, minimalValue) >= 0) continue;
            minimalValue = currentValue;
            minimalVectors.clear();
            minimalVectors.add(vector);
        }
        return minimalVectors;
    }

    public static Vector getCentroid(Collection<Vector> vectors) {
        return Addable.sum(vectors).divide(vectors.size());
    }

    public static List<Vector> orthonormalizeVectors(List<Vector> vectors) {
        if (!Vectors.haveSameDimension(vectors)) {
            throw new IllegalArgumentException("All vectors need to have the same dimensionality.");
        }
        int dimension = vectors.iterator().next().getDimension();
        if (vectors.size() > dimension) {
            throw new IllegalArgumentException("The number of vectors needs to be equal or smaller than the dimension of the vectors");
        }
        ArrayList<Vector> orthonormalizedVectors = new ArrayList<Vector>();
        ArrayList<Vector> normalizedVectors = new ArrayList<Vector>();
        for (Vector vector : vectors) {
            if (orthonormalizedVectors.isEmpty()) {
                orthonormalizedVectors.add(vector);
                normalizedVectors.add(vector.normalize());
                continue;
            }
            Vector projectionSum = Vectors.accumulateGramSchmidtProjection(vector, orthonormalizedVectors);
            orthonormalizedVectors.add(projectionSum);
            normalizedVectors.add(projectionSum.normalize());
        }
        return normalizedVectors;
    }

    public static Vector gramSchmidtProjection(Vector first, Vector second) {
        if (!second.isZero()) {
            return second.multiply(first.dotProduct(second) / second.dotProduct(second));
        }
        return second;
    }

    public static Vector accumulateGramSchmidtProjection(Vector vector, List<Vector> orthogonalizedVectors) {
        Vector projectionSum = new RegularVector(vector.getDimension());
        boolean firstRun = true;
        for (Vector orthonormalizedVector : orthogonalizedVectors) {
            if (firstRun) {
                projectionSum = vector.subtract(Vectors.gramSchmidtProjection(vector, orthonormalizedVector));
                firstRun = false;
                continue;
            }
            projectionSum = projectionSum.subtract(Vectors.gramSchmidtProjection(projectionSum, orthonormalizedVector));
        }
        return projectionSum;
    }
}

