/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.vectors;

import de.bioforscher.singa.mathematics.matrices.FastMatrices;
import de.bioforscher.singa.mathematics.matrices.SquareMatrix;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.mathematics.vectors.Vector;

public class Vector3D
implements Vector {
    public static final int X_INDEX = 0;
    public static final int Y_INDEX = 1;
    public static final int Z_INDEX = 2;
    private double x;
    private double y;
    private double z;

    public Vector3D(double[] elements) {
        if (elements.length != 3) {
            throw new IllegalArgumentException("The Vector3D class is designed to handle 3 values,  but the given array contains " + elements.length + ".");
        }
        this.x = elements[0];
        this.y = elements[1];
        this.z = elements[2];
    }

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3D(Vector3D source) {
        this(source.x, source.y, source.z);
    }

    public static boolean isVector3D(Vector vector) {
        return vector.getDimension() == 3;
    }

    @Override
    public <VectorType extends Vector> VectorType as(Class<VectorType> vectorClass) {
        if (vectorClass.equals(Vector3D.class)) {
            return (VectorType)this;
        }
        if (vectorClass.equals(RegularVector.class)) {
            return (VectorType)new RegularVector(this.x, this.y, this.z);
        }
        throw new IllegalArgumentException("Can not convert Vector3D to " + vectorClass.getSimpleName());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Override
    public double getElement(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("Can only get values for available indices (0 - 3)");
    }

    @Override
    public double[] getElements() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public boolean hasSameDimensions(Vector element) {
        return element.getDimension() == 3;
    }

    @Override
    public String getDimensionAsString() {
        return "3D";
    }

    @Override
    public Vector3D additivelyInvert() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    @Override
    public Vector additiveleyInvertElement(int index) {
        switch (index) {
            case 0: {
                return this.invertX();
            }
            case 1: {
                return this.invertY();
            }
            case 2: {
                return this.invertZ();
            }
        }
        throw new IllegalArgumentException("Can only invert available indices (0 - 3)");
    }

    public Vector3D invertX() {
        return new Vector3D(-this.x, this.y, this.z);
    }

    public Vector3D invertY() {
        return new Vector3D(this.x, -this.y, this.z);
    }

    public Vector3D invertZ() {
        return new Vector3D(this.x, this.y, -this.z);
    }

    @Override
    public Vector3D add(Vector3D vector) {
        return new Vector3D(this.x + vector.x, this.y + vector.y, this.z + vector.z);
    }

    @Override
    public Vector3D add(Vector summand) {
        if (summand.getDimension() != 3) {
            throw new IllegalArgumentException("The dimensions have to be equal to perform this operation.");
        }
        return new Vector3D(this.x + summand.getElement(0), this.y + summand.getElement(1), this.z + summand.getElement(2));
    }

    @Override
    public Vector3D subtract(Vector3D vector) {
        return new Vector3D(this.x - vector.x, this.y - vector.y, this.z - vector.z);
    }

    @Override
    public Vector3D subtract(Vector subtrahend) {
        if (subtrahend.getDimension() != 3) {
            throw new IllegalArgumentException("The dimensions have to be equal to perform this operation.");
        }
        return new Vector3D(this.x - subtrahend.getElement(0), this.y - subtrahend.getElement(1), this.z - subtrahend.getElement(2));
    }

    @Override
    public Vector3D multiply(double scalar) {
        return new Vector3D(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    @Override
    public Vector3D multiply(Vector3D vector) {
        return new Vector3D(this.x * vector.x, this.y * vector.y, this.z * vector.z);
    }

    @Override
    public Vector3D multiply(Vector multiplicand) {
        if (multiplicand.getDimension() != 3) {
            throw new IllegalArgumentException("The dimensions have to be equal to perform this operation.");
        }
        return new Vector3D(this.x * multiplicand.getElement(0), this.y * multiplicand.getElement(1), this.z * multiplicand.getElement(2));
    }

    @Override
    public Vector3D divide(double scalar) {
        return new Vector3D(this.x / scalar, this.y / scalar, this.z / scalar);
    }

    @Override
    public Vector3D divide(Vector3D vector) {
        return new Vector3D(this.x / vector.x, this.y / vector.y, this.z / vector.z);
    }

    @Override
    public Vector3D divide(Vector divisor) {
        if (divisor.getDimension() != 3) {
            throw new IllegalArgumentException("The dimensions have to be equal to perform this operation.");
        }
        return new Vector3D(this.x / divisor.getElement(0), this.y / divisor.getElement(1), this.z / divisor.getElement(2));
    }

    @Override
    public Vector3D normalize() {
        return this.divide(this.getMagnitude());
    }

    public double dotProduct(Vector3D vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    @Override
    public double dotProduct(Vector vector) {
        return this.x * vector.getElement(0) + this.y * vector.getElement(1) + this.z * vector.getElement(2);
    }

    @Override
    public double getMagnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public SquareMatrix dyadicProduct(Vector vector) {
        if (vector.getDimension() != 3) {
            throw new IllegalArgumentException("The dimensions have to be equal to perform this operation.");
        }
        double[][] values = new double[][]{{this.x * vector.getElement(0)}, {this.x * vector.getElement(1)}, {this.x * vector.getElement(2)}, {this.y * vector.getElement(0)}, {this.y * vector.getElement(1)}, {this.y * vector.getElement(2)}, {this.z * vector.getElement(0)}, {this.z * vector.getElement(1)}, {this.z * vector.getElement(2)}};
        return FastMatrices.createSquareMatrix(values);
    }

    public Vector3D crossProduct(Vector3D vector) {
        return new Vector3D(this.y * vector.z - this.z * vector.y, this.z * vector.x - this.x * vector.z, this.x * vector.y - this.y * vector.x);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector3D vector3D = (Vector3D)o;
        if (Double.compare(vector3D.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(vector3D.y, this.y) != 0) {
            return false;
        }
        return Double.compare(vector3D.z, this.z) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ')';
    }
}

