/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.vectors;

import de.bioforscher.singa.mathematics.geometry.edges.Line;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.mathematics.vectors.Vector;

public class Vector2D
extends RegularVector {
    public static final int X_INDEX = 0;
    public static final int Y_INDEX = 1;

    public Vector2D(double[] elements) {
        super(elements);
        if (elements.length != 2) {
            throw new IllegalArgumentException("The Vector2D class is designed to handle 2 values,  but the given array contains " + elements.length + ".");
        }
    }

    public Vector2D(double x, double y) {
        this(new double[]{x, y});
    }

    public Vector2D() {
        this(0.0, 0.0);
    }

    public static boolean isVector2D(Vector vector) {
        return vector.getDimension() == 2;
    }

    public double getX() {
        return this.getElement(0);
    }

    public double getY() {
        return this.getElement(1);
    }

    @Override
    public Vector2D additivelyInvert() {
        return new Vector2D(-this.getX(), -this.getY());
    }

    public Vector2D invertX() {
        return new Vector2D(-this.getX(), this.getY());
    }

    public Vector2D invertY() {
        return new Vector2D(this.getX(), -this.getY());
    }

    @Override
    public Vector2D add(Vector2D vector) {
        return new Vector2D(this.getX() + vector.getX(), this.getY() + vector.getY());
    }

    @Override
    public Vector2D subtract(Vector2D vector) {
        return new Vector2D(this.getX() - vector.getX(), this.getY() - vector.getY());
    }

    @Override
    public Vector2D multiply(Vector2D vector) {
        return new Vector2D(this.getX() * vector.getX(), this.getY() * vector.getY());
    }

    @Override
    public Vector2D multiply(double scalar) {
        return new Vector2D(this.getX() * scalar, this.getY() * scalar);
    }

    @Override
    public Vector2D divide(Vector2D vector) {
        return new Vector2D(this.getX() / vector.getX(), this.getY() / vector.getY());
    }

    @Override
    public Vector2D divide(double scalar) {
        return new Vector2D(this.getX() / scalar, this.getY() / scalar);
    }

    @Override
    public Vector2D normalize() {
        return this.divide(this.getMagnitude());
    }

    public double dotProduct(Vector2D vector) {
        return this.getX() * vector.getX() + this.getY() * vector.getY();
    }

    public double angleTo(Vector2D vector) {
        return Math.acos(this.dotProduct(vector) / (this.getMagnitude() * vector.getMagnitude()));
    }

    public Vector2D getMidpointTo(Vector2D vector) {
        return new Vector2D((this.getX() + vector.getX()) / 2.0, (this.getY() + vector.getY()) / 2.0);
    }

    @Override
    public double distanceTo(Line line) {
        return 0.0;
    }

    public boolean isNearVector(Vector2D vector, double radius) {
        double dy;
        double dx = Math.abs(vector.getX() - this.getX() - radius);
        return dx * dx + (dy = Math.abs(vector.getY() - this.getY() - radius)) * dy <= radius * radius;
    }

    public boolean canBePlacedIn(Rectangle rectangle) {
        return this.valueOfXIsBetween(rectangle.getLeftMostXPosition(), rectangle.getRightMostXPosition()) && this.valueOfYIsBetween(rectangle.getBottomMostYPosition(), rectangle.getTopMostYPosition());
    }

    public boolean isAbove(Vector2D vector) {
        return this.getY() < vector.getY();
    }

    public boolean isBelow(Vector2D vector) {
        return this.getY() > vector.getY();
    }

    public boolean isLeftOf(Vector2D vector2D) {
        return this.getX() < vector2D.getX();
    }

    public boolean isRightOf(Vector2D vector2D) {
        return this.getX() > vector2D.getX();
    }

    public boolean valueOfXIsBetween(double origin, double boundary) {
        return this.getX() < boundary && this.getX() > origin;
    }

    private boolean valueOfYIsBetween(double origin, double boundary) {
        return this.getY() < boundary && this.getY() > origin;
    }
}

