/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.vectors;

import de.bioforscher.singa.mathematics.concepts.Divisible;
import de.bioforscher.singa.mathematics.concepts.MultiDimensional;
import de.bioforscher.singa.mathematics.concepts.Ring;
import de.bioforscher.singa.mathematics.matrices.Matrix;
import de.bioforscher.singa.mathematics.metrics.model.Metric;
import de.bioforscher.singa.mathematics.metrics.model.Metrizable;
import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.function.BiConsumer;
import java.util.stream.DoubleStream;

public interface Vector
extends Ring<Vector>,
MultiDimensional<Vector>,
Divisible<Vector>,
Metrizable<Vector> {
    public <VectorType extends Vector> VectorType as(Class<VectorType> var1);

    public double getElement(int var1);

    public double[] getElements();

    default public DoubleStream streamElements() {
        return DoubleStream.of(this.getElements());
    }

    default public void forEach(BiConsumer<Integer, Double> action) {
        for (int i = 0; i < this.getDimension(); ++i) {
            action.accept(i, this.getElement(i));
        }
    }

    default public <V extends Vector> V getCopy() {
        double[] copyOfElements = new double[this.getElements().length];
        System.arraycopy(this.getElements(), 0, copyOfElements, 0, this.getElements().length);
        try {
            return (V)((Vector)this.getClass().getConstructor(double[].class).newInstance(new Object[]{copyOfElements}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Instance types must match to copy successfully.");
        }
    }

    public int getDimension();

    public Vector additiveleyInvertElement(int var1);

    @Override
    public Vector multiply(double var1);

    @Override
    public Vector divide(double var1);

    public Vector normalize();

    public double dotProduct(Vector var1);

    public double getMagnitude();

    public Matrix dyadicProduct(Vector var1);

    @Override
    default public double distanceTo(Vector another) {
        this.assertThatDimensionsMatch(another);
        return VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistance(this, another);
    }

    @Override
    default public double distanceTo(Vector another, Metric<Vector> metric) {
        this.assertThatDimensionsMatch(another);
        return metric.calculateDistance(this, another);
    }

    default public double angleTo(Vector another) {
        this.assertThatDimensionsMatch(another);
        return Math.acos(this.dotProduct(another) / (this.getMagnitude() * another.getMagnitude()));
    }

    default public boolean isZero() {
        for (double element : this.getElements()) {
            if (element == 0.0) continue;
            return false;
        }
        return true;
    }
}

