/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.vectors;

import de.bioforscher.singa.mathematics.matrices.RegularMatrix;
import de.bioforscher.singa.mathematics.vectors.Vector;

public class Scalar
implements Vector {
    private static final int dimension = 1;
    private final double value;

    public Scalar(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public <V extends Vector> V as(Class<V> vectorClass) {
        return null;
    }

    @Override
    public double getElement(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Scalar can only contain a single value at index 0.");
        }
        return this.value;
    }

    @Override
    public double[] getElements() {
        return new double[]{this.value};
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public String getDimensionAsString() {
        return String.valueOf(1) + "D";
    }

    @Override
    public boolean hasSameDimensions(Vector element) {
        return element.getDimension() == 1;
    }

    @Override
    public Scalar add(Vector summand) {
        this.assertThatDimensionsMatch(summand);
        return new Scalar(this.value + summand.getElement(0));
    }

    @Override
    public Scalar subtract(Vector subtrahend) {
        this.assertThatDimensionsMatch(subtrahend);
        return new Scalar(this.value - subtrahend.getElement(0));
    }

    @Override
    public Scalar additivelyInvert() {
        return new Scalar(-this.value);
    }

    @Override
    public Scalar additiveleyInvertElement(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("A scalar can only contain a single value at index 0.");
        }
        return this.additivelyInvert();
    }

    @Override
    public Scalar multiply(Vector multiplicand) {
        this.assertThatDimensionsMatch(multiplicand);
        return this.multiply(multiplicand.getElement(0));
    }

    @Override
    public Scalar multiply(double scalar) {
        return new Scalar(this.value * scalar);
    }

    @Override
    public Scalar divide(Vector divisor) {
        this.assertThatDimensionsMatch(divisor);
        return this.divide(divisor.getElement(0));
    }

    @Override
    public Scalar divide(double scalar) {
        return new Scalar(this.value / scalar);
    }

    @Override
    public Scalar normalize() {
        return new Scalar(this.value);
    }

    @Override
    public double dotProduct(Vector vector) {
        this.assertThatDimensionsMatch(vector);
        return this.multiply(vector.getElement(0)).getValue();
    }

    @Override
    public RegularMatrix dyadicProduct(Vector vector) {
        return new RegularMatrix(new double[][]{{this.multiply(vector.getElement(0)).getValue()}});
    }

    @Override
    public double getMagnitude() {
        return this.value;
    }

    @Override
    public double distanceTo(Vector another) {
        this.assertThatDimensionsMatch(another);
        return Math.abs(this.subtract(another).getValue());
    }
}

