/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.similarities;

import java.util.ArrayList;
import java.util.List;

public class RankBiasedOverlap {
    private final List<?> list1;
    private final List<?> list2;
    private final int limit;
    private final double p;
    private double rbo;

    public RankBiasedOverlap(List<?> list1, List<?> list2, int limit, double p) {
        this.list1 = list1;
        this.list2 = list2;
        this.limit = limit;
        this.p = p;
        if (limit > list1.size() || limit > list2.size()) {
            throw new IllegalArgumentException("The limit cannot exceed the list sizes.");
        }
        this.calculateRbo();
    }

    private void calculateRbo() {
        this.rbo = 0.0;
        for (int i = 1; i < this.limit; ++i) {
            ArrayList subList1 = new ArrayList(this.list1.subList(0, i));
            ArrayList subList2 = new ArrayList(this.list2.subList(0, i));
            subList1.retainAll(subList2);
            double a = (double)subList1.size() / (double)i;
            this.rbo += Math.pow(this.p, i - 1) * a;
        }
        this.rbo = (1.0 - this.p) * this.rbo;
    }

    public double getRbo() {
        return this.rbo;
    }
}

