/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.mathematics.metrics.model;

import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.matrices.SymmetricMatrix;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface Metric<MetrizableType> {
    public double calculateDistance(MetrizableType var1, MetrizableType var2);

    default public <SubType extends MetrizableType> SymmetricMatrix calculateDistancesPairwise(List<SubType> list) {
        int rowIndex;
        double[][] compactValues = new double[list.size()][];
        for (rowIndex = 0; rowIndex < list.size(); ++rowIndex) {
            compactValues[rowIndex] = new double[rowIndex + 1];
        }
        for (rowIndex = 0; rowIndex < compactValues.length; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < compactValues[rowIndex].length; ++columnIndex) {
                compactValues[rowIndex][columnIndex] = this.calculateDistance(list.get(rowIndex), list.get(columnIndex));
            }
        }
        return new SymmetricMatrix(compactValues);
    }

    default public <LabelType, SubType extends MetrizableType> LabeledSymmetricMatrix<LabelType> calculateDistancesPairwise(List<LabelType> list, Function<LabelType, SubType> function) {
        int rowIndex;
        double[][] compactValues = new double[list.size()][];
        for (rowIndex = 0; rowIndex < list.size(); ++rowIndex) {
            compactValues[rowIndex] = new double[rowIndex + 1];
        }
        for (rowIndex = 0; rowIndex < compactValues.length; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < compactValues[rowIndex].length; ++columnIndex) {
                compactValues[rowIndex][columnIndex] = this.calculateDistance(function.apply(list.get(rowIndex)), function.apply(list.get(columnIndex)));
            }
        }
        LabeledSymmetricMatrix<LabelType> labeledSymmetricMatrix = new LabeledSymmetricMatrix<LabelType>(compactValues);
        labeledSymmetricMatrix.setColumnLabels(list);
        return labeledSymmetricMatrix;
    }

    default public <SubType extends MetrizableType> Map<SubType, Double> calculateDistancesToReference(List<SubType> list, SubType reference) {
        HashMap result = new HashMap();
        list.forEach(point -> result.put(point, this.calculateDistance(point, reference)));
        return result;
    }

    default public <SubType extends MetrizableType> Map.Entry<SubType, Double> calculateClosestDistance(List<SubType> list, SubType reference) {
        Map<SubType, Double> distances = this.calculateDistancesToReference(list, reference);
        Map.Entry<SubType, Double> min = null;
        for (Map.Entry<SubType, Double> entry : distances.entrySet()) {
            if (min != null && !((Double)min.getValue() > entry.getValue())) continue;
            min = entry;
        }
        return min;
    }
}

